/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.gradle.dsl.Manifest;
import io.quarkus.gradle.tasks.BaseConfig;
import io.quarkus.gradle.tasks.EffectiveConfig;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.smallrye.common.expression.Expression;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.process.JavaForkOptions;

public abstract class AbstractQuarkusExtension {
    private static final String MANIFEST_SECTIONS_PROPERTY_PREFIX = "quarkus.package.jar.manifest.sections";
    private static final String MANIFEST_ATTRIBUTES_PROPERTY_PREFIX = "quarkus.package.jar.manifest.attributes";
    protected static final String QUARKUS_PROFILE = "quarkus.profile";
    protected final Project project;
    protected final File projectDir;
    protected final Property<String> finalName;
    private final MapProperty<String, String> forcedPropertiesProperty;
    protected final MapProperty<String, String> quarkusBuildProperties;
    protected final ListProperty<String> cachingRelevantProperties;
    private final ListProperty<String> ignoredEntries;
    private final FileCollection classpath;
    private final Property<BaseConfig> baseConfig;
    protected final List<Action<? super JavaForkOptions>> codeGenForkOptions;
    protected final List<Action<? super JavaForkOptions>> buildForkOptions;

    protected AbstractQuarkusExtension(Project project) {
        this.project = project;
        this.projectDir = project.getProjectDir();
        this.finalName = project.getObjects().property(String.class);
        this.finalName.convention(project.provider(() -> String.format("%s-%s", project.getName(), project.getVersion())));
        this.forcedPropertiesProperty = project.getObjects().mapProperty(String.class, String.class);
        this.quarkusBuildProperties = project.getObjects().mapProperty(String.class, String.class);
        this.cachingRelevantProperties = project.getObjects().listProperty(String.class).value(List.of("quarkus[.].*", "platform[.]quarkus[.].*"));
        this.ignoredEntries = project.getObjects().listProperty(String.class);
        this.ignoredEntries.convention(project.provider(() -> this.baseConfig().packageConfig().jar().userConfiguredIgnoredEntries().orElse(Collections.emptyList())));
        this.baseConfig = project.getObjects().property(BaseConfig.class).value(project.provider(this::buildBaseConfig));
        SourceSet mainSourceSet = QuarkusGradleUtils.getSourceSet(project, "main");
        this.classpath = AbstractQuarkusExtension.dependencyClasspath(mainSourceSet);
        this.codeGenForkOptions = new ArrayList<Action<? super JavaForkOptions>>();
        this.buildForkOptions = new ArrayList<Action<? super JavaForkOptions>>();
    }

    private BaseConfig buildBaseConfig() {
        Set resourcesDirs = QuarkusGradleUtils.getSourceSet(this.project, "main").getResources().getSourceDirectories().getFiles();
        this.project.getExtensions().getExtraProperties().getProperties().forEach((k, v) -> {
            if (k.startsWith("quarkus.")) {
                this.forcedPropertiesProperty.put(k, (Object)v.toString());
            }
        });
        EffectiveConfig effectiveConfig = EffectiveConfig.builder().withForcedProperties((Map)this.forcedPropertiesProperty.get()).withTaskProperties(Collections.emptyMap()).withBuildProperties((Map)this.quarkusBuildProperties.get()).withProjectProperties(this.project.getProperties()).withSourceDirectories(resourcesDirs).withProfile(this.quarkusProfile()).build();
        return new BaseConfig(effectiveConfig);
    }

    protected BaseConfig baseConfig() {
        this.baseConfig.finalizeValue();
        return (BaseConfig)this.baseConfig.get();
    }

    protected MapProperty<String, String> forcedPropertiesProperty() {
        return this.forcedPropertiesProperty;
    }

    protected ListProperty<String> ignoredEntriesProperty() {
        return this.ignoredEntries;
    }

    protected FileCollection classpath() {
        return this.classpath;
    }

    protected Manifest manifest() {
        return this.baseConfig().manifest();
    }

    protected EffectiveConfig buildEffectiveConfiguration(ResolvedDependency appArtifact) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.exportCustomManifestProperties(properties);
        Set resourcesDirs = QuarkusGradleUtils.getSourceSet(this.project, "main").getResources().getSourceDirectories().getFiles();
        this.project.getExtensions().getExtraProperties().getProperties().forEach((k, v) -> {
            if (k.startsWith("quarkus.")) {
                this.forcedPropertiesProperty.put(k, (Object)v.toString());
            }
        });
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        String userIgnoredEntries = String.join((CharSequence)",", (Iterable)this.ignoredEntries.get());
        if (!userIgnoredEntries.isEmpty()) {
            defaultProperties.put("quarkus.package.jar.user-configured-ignored-entries", userIgnoredEntries);
        }
        defaultProperties.putIfAbsent("quarkus.application.name", appArtifact.getArtifactId());
        defaultProperties.putIfAbsent("quarkus.application.version", appArtifact.getVersion());
        return EffectiveConfig.builder().withForcedProperties((Map)this.forcedPropertiesProperty.get()).withTaskProperties(properties).withBuildProperties((Map)this.quarkusBuildProperties.get()).withProjectProperties(this.project.getProperties()).withDefaultProperties(defaultProperties).withSourceDirectories(resourcesDirs).withProfile(this.quarkusProfile()).build();
    }

    protected Map<String, String> buildSystemProperties(ResolvedDependency appArtifact, Map<String, String> quarkusProperties) {
        HashMap<String, String> buildSystemProperties = new HashMap<String, String>();
        buildSystemProperties.putIfAbsent("quarkus.application.name", appArtifact.getArtifactId());
        buildSystemProperties.putIfAbsent("quarkus.application.version", appArtifact.getVersion());
        for (Map.Entry entry : ((Map)this.forcedPropertiesProperty.get()).entrySet()) {
            if (!((String)entry.getKey()).startsWith("quarkus.") && !((String)entry.getKey()).startsWith("platform.quarkus.")) continue;
            buildSystemProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : ((Map)this.quarkusBuildProperties.get()).entrySet()) {
            if (!((String)entry.getKey()).startsWith("quarkus.") && !((String)entry.getKey()).startsWith("platform.quarkus.")) continue;
            buildSystemProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : this.project.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith("quarkus.") && !((String)entry.getKey()).startsWith("platform.quarkus.") || entry.getValue() == null) continue;
            buildSystemProperties.put((String)entry.getKey(), entry.getValue().toString());
        }
        HashSet<String> quarkusValues = new HashSet<String>();
        quarkusValues.addAll(quarkusProperties.values());
        quarkusValues.addAll(buildSystemProperties.values());
        for (String value : quarkusValues) {
            Expression expression = Expression.compile((String)value, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX, Expression.Flag.NO_TRIM, Expression.Flag.NO_SMART_BRACES, Expression.Flag.DOUBLE_COLON});
            for (String reference : expression.getReferencedStrings()) {
                String expanded = (String)((Map)this.forcedPropertiesProperty.get()).get(reference);
                if (expanded != null) {
                    buildSystemProperties.put(reference, expanded);
                    continue;
                }
                expanded = (String)((Map)this.quarkusBuildProperties.get()).get(reference);
                if (expanded != null) {
                    buildSystemProperties.put(reference, expanded);
                    continue;
                }
                expanded = (String)this.project.getProperties().get(reference);
                if (expanded == null) continue;
                buildSystemProperties.put(reference, expanded);
            }
        }
        return buildSystemProperties;
    }

    private String quarkusProfile() {
        Object p;
        String profile = System.getProperty(QUARKUS_PROFILE);
        if (profile == null) {
            profile = System.getenv("QUARKUS_PROFILE");
        }
        if (profile == null) {
            profile = (String)((Map)this.quarkusBuildProperties.get()).get(QUARKUS_PROFILE);
        }
        if (profile == null && (p = this.project.getProperties().get(QUARKUS_PROFILE)) != null) {
            profile = p.toString();
        }
        if (profile == null) {
            profile = "prod";
        }
        return profile;
    }

    private static FileCollection dependencyClasspath(SourceSet mainSourceSet) {
        return mainSourceSet.getCompileClasspath().plus(mainSourceSet.getRuntimeClasspath()).plus(mainSourceSet.getAnnotationProcessorPath()).plus((FileCollection)mainSourceSet.getResources());
    }

    private void exportCustomManifestProperties(Map<String, Object> properties) {
        for (Map.Entry entry : this.baseConfig().manifest().getAttributes().entrySet()) {
            properties.put(AbstractQuarkusExtension.toManifestAttributeKey((String)entry.getKey()), entry.getValue());
        }
        for (Map.Entry entry : this.baseConfig().manifest().getSections().entrySet()) {
            for (Map.Entry attribute : ((Attributes)entry.getValue()).entrySet()) {
                properties.put(AbstractQuarkusExtension.toManifestSectionAttributeKey((String)entry.getKey(), (String)attribute.getKey()), attribute.getValue());
            }
        }
    }

    protected static String toManifestAttributeKey(String key) {
        if (key.contains("\"")) {
            throw new GradleException("Manifest entry name " + key + " is invalid. \" characters are not allowed.");
        }
        return String.format("%s.\"%s\"", MANIFEST_ATTRIBUTES_PROPERTY_PREFIX, key);
    }

    protected static String toManifestSectionAttributeKey(String section, String key) {
        if (section.contains("\"")) {
            throw new GradleException("Manifest section name " + section + " is invalid. \" characters are not allowed.");
        }
        if (key.contains("\"")) {
            throw new GradleException("Manifest entry name " + key + " is invalid. \" characters are not allowed.");
        }
        return String.format("%s.\"%s\".\"%s\"", MANIFEST_SECTIONS_PROPERTY_PREFIX, section, key);
    }
}

