/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.AnnotationsOverlay;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import io.quarkus.arc.processor.bcextensions.FieldInfoImpl;
import io.quarkus.arc.processor.bcextensions.MethodInfoImpl;
import io.quarkus.arc.processor.bcextensions.ParameterInfoImpl;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.DeclarationInfo;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

abstract class DeclarationInfoImpl<JandexDeclaration extends AnnotationTarget>
implements DeclarationInfo {
    final IndexView jandexIndex;
    final AllAnnotationOverlays annotationOverlays;
    final JandexDeclaration jandexDeclaration;

    DeclarationInfoImpl(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, JandexDeclaration jandexDeclaration) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlays = annotationOverlays;
        this.jandexDeclaration = jandexDeclaration;
    }

    static DeclarationInfo fromJandexDeclaration(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, AnnotationTarget jandexDeclaration) {
        switch (jandexDeclaration.kind()) {
            case CLASS: {
                return new ClassInfoImpl(jandexIndex, annotationOverlays, jandexDeclaration.asClass());
            }
            case METHOD: {
                return new MethodInfoImpl(jandexIndex, annotationOverlays, jandexDeclaration.asMethod());
            }
            case METHOD_PARAMETER: {
                return new ParameterInfoImpl(jandexIndex, annotationOverlays, jandexDeclaration.asMethodParameter());
            }
            case FIELD: {
                return new FieldInfoImpl(jandexIndex, annotationOverlays, jandexDeclaration.asField());
            }
        }
        throw new IllegalStateException("Unknown declaration " + String.valueOf(jandexDeclaration));
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.annotationsOverlay().hasAnnotation(this.jandexDeclaration, DotName.createSimple((String)annotationType.getName()), this.jandexIndex);
    }

    public boolean hasAnnotation(Predicate<AnnotationInfo> predicate) {
        return this.annotationsOverlay().getAnnotations(this.jandexDeclaration, this.jandexIndex).annotations().stream().anyMatch(it -> predicate.test(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, (AnnotationInstance)it)));
    }

    public <T extends Annotation> AnnotationInfo annotation(Class<T> annotationType) {
        AnnotationInstance jandexAnnotation = this.annotationsOverlay().getAnnotations(this.jandexDeclaration, this.jandexIndex).annotation(annotationType);
        if (jandexAnnotation == null) {
            return null;
        }
        return new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, jandexAnnotation);
    }

    public <T extends Annotation> Collection<AnnotationInfo> repeatableAnnotation(Class<T> annotationType) {
        return this.annotationsOverlay().getAnnotations(this.jandexDeclaration, this.jandexIndex).annotationsWithRepeatable(annotationType).stream().map(it -> new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, (AnnotationInstance)it)).collect(Collectors.toUnmodifiableList());
    }

    public Collection<AnnotationInfo> annotations(Predicate<AnnotationInfo> predicate) {
        return this.annotationsOverlay().getAnnotations(this.jandexDeclaration, this.jandexIndex).annotations().stream().map(it -> new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, (AnnotationInstance)it)).filter(predicate).collect(Collectors.toUnmodifiableList());
    }

    public Collection<AnnotationInfo> annotations() {
        return this.annotations(it -> true);
    }

    abstract AnnotationsOverlay<JandexDeclaration> annotationsOverlay();

    public String toString() {
        return this.jandexDeclaration.toString();
    }
}

