/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.Types;
import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.AnnotationMemberImpl;
import io.quarkus.arc.processor.bcextensions.ArrayTypeImpl;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import io.quarkus.arc.processor.bcextensions.ClassTypeImpl;
import io.quarkus.arc.processor.bcextensions.MethodPredicates;
import io.quarkus.arc.processor.bcextensions.PrimitiveTypeImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import io.quarkus.arc.processor.bcextensions.VoidTypeImpl;
import jakarta.enterprise.inject.build.compatible.spi.AnnotationBuilder;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.AnnotationMember;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.types.ArrayType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class AnnotationBuilderImpl
implements AnnotationBuilder {
    private final IndexView jandexIndex;
    private final AllAnnotationOverlays annotationOverlays;
    private final DotName jandexClassName;
    private final List<AnnotationValue> jandexAnnotationMembers = new ArrayList<AnnotationValue>();

    AnnotationBuilderImpl(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, DotName jandexAnnotationName) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlays = annotationOverlays;
        this.jandexClassName = jandexAnnotationName;
    }

    public AnnotationBuilder member(String name, AnnotationMember value) {
        AnnotationValue jandexValue = ((AnnotationMemberImpl)value).jandexAnnotationMember;
        block0 : switch (jandexValue.kind()) {
            case BOOLEAN: {
                return this.member(name, jandexValue.asBoolean());
            }
            case BYTE: {
                return this.member(name, jandexValue.asByte());
            }
            case SHORT: {
                return this.member(name, jandexValue.asShort());
            }
            case INTEGER: {
                return this.member(name, jandexValue.asInt());
            }
            case LONG: {
                return this.member(name, jandexValue.asLong());
            }
            case FLOAT: {
                return this.member(name, jandexValue.asFloat());
            }
            case DOUBLE: {
                return this.member(name, jandexValue.asDouble());
            }
            case CHARACTER: {
                return this.member(name, jandexValue.asChar());
            }
            case STRING: {
                return this.member(name, jandexValue.asString());
            }
            case ENUM: {
                DotName enumTypeName = jandexValue.asEnumType();
                String enumValue = jandexValue.asEnum();
                this.jandexAnnotationMembers.add(AnnotationValue.createEnumValue((String)name, (DotName)enumTypeName, (String)enumValue));
                return this;
            }
            case CLASS: {
                Type jandexClass = jandexValue.asClass();
                this.jandexAnnotationMembers.add(AnnotationValue.createClassValue((String)name, (Type)jandexClass));
                return this;
            }
            case NESTED: {
                AnnotationInstance jandexAnnotation = jandexValue.asNested();
                this.jandexAnnotationMembers.add(AnnotationValue.createNestedAnnotationValue((String)name, (AnnotationInstance)jandexAnnotation));
                return this;
            }
            case ARRAY: {
                switch (jandexValue.componentKind()) {
                    case BOOLEAN: {
                        return this.member(name, jandexValue.asBooleanArray());
                    }
                    case BYTE: {
                        return this.member(name, jandexValue.asByteArray());
                    }
                    case SHORT: {
                        return this.member(name, jandexValue.asShortArray());
                    }
                    case INTEGER: {
                        return this.member(name, jandexValue.asIntArray());
                    }
                    case LONG: {
                        return this.member(name, jandexValue.asLongArray());
                    }
                    case FLOAT: {
                        return this.member(name, jandexValue.asFloatArray());
                    }
                    case DOUBLE: {
                        return this.member(name, jandexValue.asDoubleArray());
                    }
                    case CHARACTER: {
                        return this.member(name, jandexValue.asCharArray());
                    }
                    case STRING: {
                        return this.member(name, jandexValue.asStringArray());
                    }
                    case ENUM: {
                        DotName[] enumTypeNames = jandexValue.asEnumTypeArray();
                        String[] enumValues = jandexValue.asEnumArray();
                        AnnotationValue[] enumArray = new AnnotationValue[enumValues.length];
                        for (int i = 0; i < enumValues.length; ++i) {
                            enumArray[i] = AnnotationValue.createEnumValue((String)name, (DotName)enumTypeNames[i], (String)enumValues[i]);
                        }
                        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])enumArray));
                        return this;
                    }
                    case CLASS: {
                        Type[] jandexClasses = jandexValue.asClassArray();
                        AnnotationValue[] classArray = new AnnotationValue[jandexClasses.length];
                        for (int i = 0; i < jandexClasses.length; ++i) {
                            classArray[i] = AnnotationValue.createClassValue((String)name, (Type)jandexClasses[i]);
                        }
                        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])classArray));
                        return this;
                    }
                    case NESTED: {
                        AnnotationInstance[] jandexAnnotations = jandexValue.asNestedArray();
                        AnnotationValue[] annotationArray = new AnnotationValue[jandexAnnotations.length];
                        for (int i = 0; i < jandexAnnotations.length; ++i) {
                            annotationArray[i] = AnnotationValue.createNestedAnnotationValue((String)name, (AnnotationInstance)jandexAnnotations[i]);
                        }
                        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])annotationArray));
                        return this;
                    }
                    case UNKNOWN: {
                        AnnotationValue[] emptyArray = new AnnotationValue[]{};
                        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])emptyArray));
                        break block0;
                    }
                    case ARRAY: {
                        throw new IllegalStateException("Array component is array, this should never happen: " + String.valueOf(jandexValue));
                    }
                }
                break;
            }
            case UNKNOWN: {
                throw new IllegalStateException("Unknown annotation member, this should never happen: " + String.valueOf(jandexValue));
            }
        }
        return this;
    }

    public AnnotationBuilder member(String name, boolean value) {
        this.jandexAnnotationMembers.add(AnnotationValue.createBooleanValue((String)name, (boolean)value));
        return this;
    }

    public AnnotationBuilder member(String name, boolean[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createBooleanValue((String)name, (boolean)values[i]);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, byte value) {
        this.jandexAnnotationMembers.add(AnnotationValue.createByteValue((String)name, (byte)value));
        return this;
    }

    public AnnotationBuilder member(String name, byte[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createByteValue((String)name, (byte)values[i]);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, short value) {
        this.jandexAnnotationMembers.add(AnnotationValue.createShortValue((String)name, (short)value));
        return this;
    }

    public AnnotationBuilder member(String name, short[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createShortValue((String)name, (short)values[i]);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, int value) {
        this.jandexAnnotationMembers.add(AnnotationValue.createIntegerValue((String)name, (int)value));
        return this;
    }

    public AnnotationBuilder member(String name, int[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createIntegerValue((String)name, (int)values[i]);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, long value) {
        this.jandexAnnotationMembers.add(AnnotationValue.createLongValue((String)name, (long)value));
        return this;
    }

    public AnnotationBuilder member(String name, long[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createLongValue((String)name, (long)values[i]);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, float value) {
        this.jandexAnnotationMembers.add(AnnotationValue.createFloatValue((String)name, (float)value));
        return this;
    }

    public AnnotationBuilder member(String name, float[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createFloatValue((String)name, (float)values[i]);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, double value) {
        this.jandexAnnotationMembers.add(AnnotationValue.createDoubleValue((String)name, (double)value));
        return this;
    }

    public AnnotationBuilder member(String name, double[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createDoubleValue((String)name, (double)values[i]);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, char value) {
        this.jandexAnnotationMembers.add(AnnotationValue.createCharacterValue((String)name, (char)value));
        return this;
    }

    public AnnotationBuilder member(String name, char[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createCharacterValue((String)name, (char)values[i]);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, String value) {
        this.jandexAnnotationMembers.add(AnnotationValue.createStringValue((String)name, (String)value));
        return this;
    }

    public AnnotationBuilder member(String name, String[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createStringValue((String)name, (String)values[i]);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, Enum<?> value) {
        DotName enumTypeName = DotName.createSimple((String)value.getDeclaringClass().getName());
        String enumValue = value.name();
        this.jandexAnnotationMembers.add(AnnotationValue.createEnumValue((String)name, (DotName)enumTypeName, (String)enumValue));
        return this;
    }

    public AnnotationBuilder member(String name, Enum<?>[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            DotName enumTypeName = DotName.createSimple((String)values[i].getDeclaringClass().getName());
            String enumValue = values[i].name();
            array[i] = AnnotationValue.createEnumValue((String)name, (DotName)enumTypeName, (String)enumValue);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, Class<? extends Enum<?>> enumType, String enumValue) {
        DotName enumTypeName = DotName.createSimple((String)enumType.getName());
        this.jandexAnnotationMembers.add(AnnotationValue.createEnumValue((String)name, (DotName)enumTypeName, (String)enumValue));
        return this;
    }

    public AnnotationBuilder member(String name, Class<? extends Enum<?>> enumType, String[] enumValues) {
        AnnotationValue[] array = new AnnotationValue[enumValues.length];
        DotName enumTypeName = DotName.createSimple((String)enumType.getName());
        for (int i = 0; i < enumValues.length; ++i) {
            array[i] = AnnotationValue.createEnumValue((String)name, (DotName)enumTypeName, (String)enumValues[i]);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, ClassInfo enumType, String enumValue) {
        DotName enumTypeName = ((org.jboss.jandex.ClassInfo)((ClassInfoImpl)enumType).jandexDeclaration).name();
        this.jandexAnnotationMembers.add(AnnotationValue.createEnumValue((String)name, (DotName)enumTypeName, (String)enumValue));
        return this;
    }

    public AnnotationBuilder member(String name, ClassInfo enumType, String[] enumValues) {
        AnnotationValue[] array = new AnnotationValue[enumValues.length];
        DotName enumTypeName = ((org.jboss.jandex.ClassInfo)((ClassInfoImpl)enumType).jandexDeclaration).name();
        for (int i = 0; i < enumValues.length; ++i) {
            array[i] = AnnotationValue.createEnumValue((String)name, (DotName)enumTypeName, (String)enumValues[i]);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, Class<?> value) {
        this.jandexAnnotationMembers.add(AnnotationValue.createClassValue((String)name, (Type)Types.jandexType(value)));
        return this;
    }

    public AnnotationBuilder member(String name, Class<?>[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createClassValue((String)name, (Type)Types.jandexType(values[i]));
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, ClassInfo value) {
        DotName className = ((org.jboss.jandex.ClassInfo)((ClassInfoImpl)value).jandexDeclaration).name();
        Type jandexClass = Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS);
        this.jandexAnnotationMembers.add(AnnotationValue.createClassValue((String)name, (Type)jandexClass));
        return this;
    }

    public AnnotationBuilder member(String name, ClassInfo[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            DotName className = ((org.jboss.jandex.ClassInfo)((ClassInfoImpl)values[i]).jandexDeclaration).name();
            Type jandexClass = Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS);
            array[i] = AnnotationValue.createClassValue((String)name, (Type)jandexClass);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    private void validateType(jakarta.enterprise.lang.model.types.Type type) {
        if (type instanceof VoidTypeImpl) {
            return;
        }
        if (type instanceof PrimitiveTypeImpl) {
            return;
        }
        if (type instanceof ClassTypeImpl) {
            return;
        }
        if (type instanceof ArrayTypeImpl) {
            ArrayType arrayType = type.asArray();
            jakarta.enterprise.lang.model.types.Type elementType = arrayType.componentType();
            while (elementType.isArray()) {
                elementType = elementType.asArray().componentType();
            }
            if (elementType instanceof PrimitiveTypeImpl) {
                return;
            }
            if (elementType instanceof ClassTypeImpl) {
                return;
            }
        }
        throw new IllegalArgumentException("Illegal type " + String.valueOf(type));
    }

    public AnnotationBuilder member(String name, jakarta.enterprise.lang.model.types.Type value) {
        this.validateType(value);
        Object jandexClass = ((TypeImpl)value).jandexType;
        this.jandexAnnotationMembers.add(AnnotationValue.createClassValue((String)name, jandexClass));
        return this;
    }

    public AnnotationBuilder member(String name, jakarta.enterprise.lang.model.types.Type[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.validateType(values[i]);
            Object jandexClass = ((TypeImpl)values[i]).jandexType;
            array[i] = AnnotationValue.createClassValue((String)name, jandexClass);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, AnnotationInfo value) {
        AnnotationInstance jandexAnnotation = ((AnnotationInfoImpl)value).jandexAnnotation;
        this.jandexAnnotationMembers.add(AnnotationValue.createNestedAnnotationValue((String)name, (AnnotationInstance)jandexAnnotation));
        return this;
    }

    public AnnotationBuilder member(String name, AnnotationInfo[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            AnnotationInstance jandexAnnotation = ((AnnotationInfoImpl)values[i]).jandexAnnotation;
            array[i] = AnnotationValue.createNestedAnnotationValue((String)name, (AnnotationInstance)jandexAnnotation);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationBuilder member(String name, Annotation value) {
        AnnotationInstance jandexAnnotation = Annotations.jandexAnnotation(value);
        this.jandexAnnotationMembers.add(AnnotationValue.createNestedAnnotationValue((String)name, (AnnotationInstance)jandexAnnotation));
        return this;
    }

    public AnnotationBuilder member(String name, Annotation[] values) {
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            AnnotationInstance jandexAnnotation = Annotations.jandexAnnotation(values[i]);
            array[i] = AnnotationValue.createNestedAnnotationValue((String)name, (AnnotationInstance)jandexAnnotation);
        }
        this.jandexAnnotationMembers.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])array));
        return this;
    }

    public AnnotationInfo build() {
        org.jboss.jandex.ClassInfo jandexAnnotationClass = this.jandexIndex.getClassByName(this.jandexClassName);
        if (jandexAnnotationClass == null) {
            throw new IllegalStateException("Annotation class " + String.valueOf(this.jandexClassName) + " not present in the bean archive");
        }
        if (!jandexAnnotationClass.isAnnotation()) {
            throw new IllegalStateException("Class " + String.valueOf(this.jandexClassName) + " is not an annotation type");
        }
        for (MethodInfo jandexAnnotationMember : jandexAnnotationClass.methods().stream().filter(MethodPredicates.IS_METHOD_JANDEX).collect(Collectors.toUnmodifiableList())) {
            if (jandexAnnotationMember.defaultValue() != null || !this.jandexAnnotationMembers.stream().filter(it -> it.name().equals(jandexAnnotationMember.name())).findAny().isEmpty()) continue;
            throw new IllegalStateException("Annotation member " + jandexAnnotationClass.simpleName() + "." + jandexAnnotationMember.name() + " not added to the AnnotationBuilder, and it doesn't have a default value");
        }
        AnnotationInstance jandexAnnotation = AnnotationInstance.create((DotName)this.jandexClassName, null, this.jandexAnnotationMembers);
        return new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, jandexAnnotation);
    }
}

