/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.CustomAlterableContexts;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Gizmo;
import java.util.Collection;
import org.jboss.logging.Logger;

class CustomAlterableContextsGenerator
extends AbstractGenerator {
    private static final Logger LOGGER = Logger.getLogger(CustomAlterableContextsGenerator.class);

    CustomAlterableContextsGenerator(boolean generateSources) {
        super(generateSources);
    }

    Collection<ResourceOutput.Resource> generate(CustomAlterableContexts.CustomAlterableContextInfo info) {
        ResourceClassOutput classOutput = new ResourceClassOutput(info.isApplicationClass, this.generateSources);
        this.createInjectableContextSubclass(classOutput, info);
        return classOutput.getResources();
    }

    private void createInjectableContextSubclass(ClassOutput classOutput, CustomAlterableContexts.CustomAlterableContextInfo info) {
        Gizmo gizmo = CustomAlterableContextsGenerator.gizmo(classOutput);
        gizmo.class_(info.generatedName, cc -> {
            cc.extends_(info.contextClass);
            cc.implements_(InjectableContext.class);
            cc.defaultConstructor();
            if (info.isNormal != null) {
                cc.method("isNormal", mc -> {
                    mc.returning(Boolean.TYPE);
                    mc.body(bc -> bc.return_(info.isNormal.booleanValue()));
                });
            }
            cc.method("destroy", mc -> {
                mc.returning(Void.TYPE);
                mc.body(bc -> bc.throw_(UnsupportedOperationException.class, "Custom AlterableContext cannot destroy all instances"));
            });
            cc.method("getState", mc -> {
                mc.returning(InjectableContext.ContextState.class);
                mc.body(bc -> bc.throw_(UnsupportedOperationException.class, "Custom AlterableContext has no state"));
            });
            cc.method("destroy", mc -> {
                mc.returning(Void.TYPE);
                mc.parameter("state", InjectableContext.ContextState.class);
                mc.body(bc -> bc.throw_(UnsupportedOperationException.class, "Custom AlterableContext has no state"));
            });
        });
        LOGGER.debugf("InjectableContext subclass generated: %s", (Object)info.generatedName);
    }
}

