/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.AbstractAnnotationLiteral;
import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import java.lang.annotation.Annotation;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;
import org.jboss.jandex.gizmo2.StringBuilderGen;
import org.jboss.logging.Logger;

public class AnnotationLiteralGenerator
extends AbstractGenerator {
    private static final Logger LOGGER = Logger.getLogger(AnnotationLiteralGenerator.class);
    private static final MethodDesc FLOAT_TO_INT_BITS = MethodDesc.of(Float.class, (String)"floatToIntBits", Integer.TYPE, (Class[])new Class[]{Float.TYPE});
    private static final MethodDesc DOUBLE_TO_LONG_BITS = MethodDesc.of(Double.class, (String)"doubleToLongBits", Long.TYPE, (Class[])new Class[]{Double.TYPE});

    AnnotationLiteralGenerator(boolean generateSources) {
        super(generateSources);
    }

    Collection<ResourceOutput.Resource> generate(ComputingCache<AnnotationLiteralProcessor.CacheKey, AnnotationLiteralProcessor.AnnotationLiteralClassInfo> cache, Set<String> existingClasses) {
        ArrayList<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
        cache.forEachExistingValue(literal -> {
            ResourceClassOutput classOutput = new ResourceClassOutput(literal.isApplicationClass, this.generateSources);
            this.createAnnotationLiteralClass(classOutput, (AnnotationLiteralProcessor.AnnotationLiteralClassInfo)literal, existingClasses);
            resources.addAll(classOutput.getResources());
        });
        return resources;
    }

    Collection<Future<Collection<ResourceOutput.Resource>>> generate(ComputingCache<AnnotationLiteralProcessor.CacheKey, AnnotationLiteralProcessor.AnnotationLiteralClassInfo> cache, final Set<String> existingClasses, ExecutorService executor) {
        ArrayList<Future<Collection<ResourceOutput.Resource>>> futures = new ArrayList<Future<Collection<ResourceOutput.Resource>>>();
        cache.forEachExistingValue(literal -> futures.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

            @Override
            public Collection<ResourceOutput.Resource> call() throws Exception {
                ResourceClassOutput classOutput = new ResourceClassOutput(literal.isApplicationClass, AnnotationLiteralGenerator.this.generateSources);
                AnnotationLiteralGenerator.this.createAnnotationLiteralClass(classOutput, literal, existingClasses);
                return classOutput.getResources();
            }
        })));
        return futures;
    }

    private void createAnnotationLiteralClass(ClassOutput classOutput, AnnotationLiteralProcessor.AnnotationLiteralClassInfo literal, Set<String> existingClasses) {
        String generatedName = literal.generatedClassName.replace('.', '/');
        if (existingClasses.contains(generatedName)) {
            return;
        }
        Gizmo gizmo = AnnotationLiteralGenerator.gizmo(classOutput);
        gizmo.class_(literal.generatedClassName, cc -> {
            cc.extends_(AbstractAnnotationLiteral.class);
            cc.implements_(Jandex2Gizmo.classDescOf((ClassInfo)literal.annotationClass));
            List<MethodInfo> annotationMembers = literal.annotationMembers();
            int annotationMembersCount = annotationMembers.size();
            boolean memberless = annotationMembers.isEmpty();
            FieldDesc[] fields = (FieldDesc[])annotationMembers.stream().map(it -> cc.field(it.name(), fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Jandex2Gizmo.classDescOf((Type)it.returnType()));
            })).toArray(FieldDesc[]::new);
            ConstructorDesc ctor = cc.constructor(mc -> {
                if (memberless) {
                    mc.private_();
                } else {
                    mc.public_();
                }
                ParamVar[] params = (ParamVar[])annotationMembers.stream().map(it -> mc.parameter(it.name(), Jandex2Gizmo.classDescOf((Type)it.returnType()))).toArray(ParamVar[]::new);
                mc.body(bc -> {
                    bc.invokeSpecial(ConstructorDesc.of(AbstractAnnotationLiteral.class, (Class[])new Class[0]), (Expr)cc.this_());
                    for (int i = 0; i < annotationMembersCount; ++i) {
                        bc.set((Assignable)cc.this_().field(fields[i]), (Expr)params[i]);
                    }
                    bc.return_();
                });
            });
            cc.method("annotationType", mc -> {
                mc.public_();
                mc.returning(Class.class);
                mc.body(bc -> bc.return_((Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)literal.annotationClass))));
            });
            for (int i = 0; i < annotationMembersCount; ++i) {
                MethodInfo annotationMember = annotationMembers.get(i);
                FieldDesc field = fields[i];
                cc.method(annotationMember.name(), mc -> {
                    mc.public_();
                    mc.returning(Jandex2Gizmo.classDescOf((Type)annotationMember.returnType()));
                    mc.body(bc -> bc.return_((Expr)cc.this_().field(field)));
                });
            }
            if (memberless) {
                cc.staticField("INSTANCE", fc -> {
                    fc.public_();
                    fc.final_();
                    fc.setType(cc.type());
                    fc.setInitializer(bc -> bc.yield(bc.new_(ctor)));
                });
            } else {
                AnnotationLiteralGenerator.generateStaticFieldsWithDefaultValues(cc, annotationMembers);
            }
            AnnotationLiteralGenerator.generateEquals(cc, literal);
            AnnotationLiteralGenerator.generateHashCode(cc, literal);
            AnnotationLiteralGenerator.generateToString(cc, literal);
        });
        LOGGER.debugf("Annotation literal class generated: %s", (Object)literal.generatedClassName);
    }

    static String defaultValueStaticFieldName(MethodInfo annotationMember) {
        return annotationMember.name() + "_default_value";
    }

    private static boolean returnsClassOrClassArray(MethodInfo annotationMember) {
        boolean returnsClass = DotNames.CLASS.equals((Object)annotationMember.returnType().name());
        boolean returnsClassArray = annotationMember.returnType().kind() == Type.Kind.ARRAY && DotNames.CLASS.equals((Object)annotationMember.returnType().asArrayType().componentType().name());
        return returnsClass || returnsClassArray;
    }

    private static void generateStaticFieldsWithDefaultValues(ClassCreator cc, List<MethodInfo> annotationMembers) {
        ArrayList<MethodInfo> defaultOfClassType = new ArrayList<MethodInfo>();
        for (MethodInfo annotationMember : annotationMembers) {
            if (annotationMember.defaultValue() == null || !AnnotationLiteralGenerator.returnsClassOrClassArray(annotationMember)) continue;
            defaultOfClassType.add(annotationMember);
        }
        if (defaultOfClassType.isEmpty()) {
            return;
        }
        for (MethodInfo annotationMember : defaultOfClassType) {
            AnnotationValue defaultValue = annotationMember.defaultValue();
            cc.staticField(AnnotationLiteralGenerator.defaultValueStaticFieldName(annotationMember), fc -> {
                fc.public_();
                fc.final_();
                fc.setType(Jandex2Gizmo.classDescOf((Type)annotationMember.returnType()));
                fc.setInitializer(bc -> {
                    if (defaultValue.kind() == AnnotationValue.Kind.ARRAY) {
                        Type[] classes = defaultValue.asClassArray();
                        LocalVar array = bc.localVar("array", bc.newEmptyArray(Class.class, (Expr)Const.of((int)classes.length)));
                        for (int i = 0; i < classes.length; ++i) {
                            bc.set(array.elem(i), Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)classes[i])));
                        }
                        bc.yield((Expr)array);
                    } else {
                        bc.yield((Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)defaultValue.asClass())));
                    }
                });
            });
        }
    }

    private static void generateEquals(ClassCreator cc, AnnotationLiteralProcessor.AnnotationLiteralClassInfo literal) {
        cc.method("equals", mc -> {
            mc.public_();
            mc.returning(Boolean.TYPE);
            ParamVar other = mc.parameter("other", Object.class);
            mc.body(bc -> {
                bc.if_(bc.eq((Expr)cc.this_(), (Expr)other), BlockCreator::returnTrue);
                if (literal.annotationMembers().isEmpty()) {
                    bc.ifNotInstanceOf((Expr)other, ClassDesc.of(Annotation.class.getName()), BlockCreator::returnFalse);
                    Const thisAnnType = Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)literal.annotationClass));
                    Expr thatAnnType = bc.invokeInterface(MethodDesc.of(Annotation.class, (String)"annotationType", Class.class, (Class[])new Class[0]), (Expr)other);
                    bc.return_(bc.objEquals((Expr)thisAnnType, thatAnnType));
                    return;
                }
                bc.ifNotInstanceOf((Expr)other, Jandex2Gizmo.classDescOf((ClassInfo)literal.annotationClass), BlockCreator::returnFalse);
                LocalVar that = bc.localVar("that", bc.cast((Expr)other, Jandex2Gizmo.classDescOf((ClassInfo)literal.annotationClass)));
                for (MethodInfo annotationMember : literal.annotationMembers()) {
                    Expr cmp;
                    ClassDesc type = Jandex2Gizmo.classDescOf((Type)annotationMember.returnType());
                    FieldDesc field = FieldDesc.of((ClassDesc)cc.type(), (String)annotationMember.name(), (ClassDesc)type);
                    Supplier<Expr> thisValue = () -> cc.this_().field(field);
                    Supplier<Expr> thatValue = () -> bc.invokeInterface(Jandex2Gizmo.methodDescOf((MethodInfo)annotationMember), (Expr)that);
                    if (type.equals(ConstantDescs.CD_float)) {
                        Expr thisIntBits = bc.invokeStatic(FLOAT_TO_INT_BITS, thisValue.get());
                        Expr thatIntBits = bc.invokeStatic(FLOAT_TO_INT_BITS, thatValue.get());
                        cmp = bc.eq(thisIntBits, thatIntBits);
                    } else if (type.equals(ConstantDescs.CD_double)) {
                        Expr thisLongBits = bc.invokeStatic(DOUBLE_TO_LONG_BITS, thisValue.get());
                        Expr thatLongBits = bc.invokeStatic(DOUBLE_TO_LONG_BITS, thatValue.get());
                        cmp = bc.eq(thisLongBits, thatLongBits);
                    } else {
                        cmp = type.isArray() ? bc.arrayEquals(thisValue.get(), thatValue.get()) : (type.isClassOrInterface() ? bc.withObject(thisValue.get()).equals_(thatValue.get()) : bc.eq(thisValue.get(), thatValue.get()));
                    }
                    bc.ifNot(cmp, BlockCreator::returnFalse);
                }
                bc.returnTrue();
            });
        });
    }

    private static void generateHashCode(ClassCreator cc, AnnotationLiteralProcessor.AnnotationLiteralClassInfo literal) {
        cc.method("hashCode", mc -> {
            mc.public_();
            mc.returning(Integer.TYPE);
            mc.body(bc -> {
                if (literal.annotationMembers().isEmpty()) {
                    bc.return_(0);
                    return;
                }
                LocalVar result = bc.localVar("result", (Expr)Const.of((int)0));
                for (MethodInfo annotationMember : literal.annotationMembers()) {
                    Expr memberNameHash = bc.mul((Expr)Const.of((int)127), bc.withObject((Expr)Const.of((String)annotationMember.name())).hashCode_());
                    ClassDesc type = Jandex2Gizmo.classDescOf((Type)annotationMember.returnType());
                    FieldDesc field = FieldDesc.of((ClassDesc)cc.type(), (String)annotationMember.name(), (ClassDesc)type);
                    InstanceFieldVar value = cc.this_().field(field);
                    Expr memberValueHash = type.isArray() ? bc.arrayHashCode((Expr)value) : (type.isClassOrInterface() ? bc.withObject((Expr)value).hashCode_() : bc.objHashCode((Expr)value));
                    Expr xor = bc.xor(memberNameHash, memberValueHash);
                    bc.addAssign((Assignable)result, xor);
                }
                bc.return_((Expr)result);
            });
        });
    }

    private static void generateToString(ClassCreator cc, AnnotationLiteralProcessor.AnnotationLiteralClassInfo literal) {
        cc.method("toString", mc -> {
            mc.public_();
            mc.returning(String.class);
            mc.body(bc -> {
                if (literal.annotationMembers().isEmpty()) {
                    bc.return_("@" + String.valueOf(literal.annotationClass.name()) + "()");
                    return;
                }
                StringBuilderGen str = StringBuilderGen.ofNew((BlockCreator)bc);
                str.append("@" + String.valueOf(literal.annotationClass.name()) + "(");
                boolean first = true;
                for (MethodInfo annotationMember : literal.annotationMembers()) {
                    if (first) {
                        str.append(annotationMember.name() + "=");
                    } else {
                        str.append(", " + annotationMember.name() + "=");
                    }
                    ClassDesc type = Jandex2Gizmo.classDescOf((Type)annotationMember.returnType());
                    FieldDesc field = FieldDesc.of((ClassDesc)cc.type(), (String)annotationMember.name(), (ClassDesc)type);
                    InstanceFieldVar value = cc.this_().field(field);
                    str.append((Expr)(type.isArray() ? bc.arrayToString((Expr)value) : value));
                    first = false;
                }
                str.append(')');
                bc.return_(str.toString_());
            });
        });
    }
}

