/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.tck.porting;

import io.quarkus.arc.InjectableBean;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.UUID;
import org.jboss.cdi.tck.spi.Contextuals;

public class ContextualsImpl
implements Contextuals {
    public <T> Contextuals.Inspectable<T> create(T instance, Context context) {
        return new InspectableImpl<T>(instance, context.getScope());
    }

    static class InspectableImpl<T>
    implements InjectableBean<T>,
    Contextuals.Inspectable<T> {
        private final T instance;
        private final String id;
        private final Class<? extends Annotation> scope;
        private CreationalContext<T> creationalContextPassedToCreate;
        private T instancePassedToDestroy;
        private CreationalContext<T> creationalContextPassedToDestroy;

        InspectableImpl(T instance, Class<? extends Annotation> scope) {
            this.instance = instance;
            this.id = UUID.randomUUID().toString();
            this.scope = scope;
        }

        public T create(CreationalContext<T> creationalContext) {
            this.creationalContextPassedToCreate = creationalContext;
            return this.instance;
        }

        public void destroy(T instance, CreationalContext<T> creationalContext) {
            this.instancePassedToDestroy = instance;
            this.creationalContextPassedToDestroy = creationalContext;
        }

        public String getIdentifier() {
            return this.id;
        }

        public Class<? extends Annotation> getScope() {
            return this.scope;
        }

        public Set<Type> getTypes() {
            return Set.of(Object.class, this.instance.getClass());
        }

        public T get(CreationalContext<T> creationalContext) {
            return this.create(creationalContext);
        }

        public Class<?> getBeanClass() {
            return this.instance.getClass();
        }

        public CreationalContext<T> getCreationalContextPassedToCreate() {
            return this.creationalContextPassedToCreate;
        }

        public T getInstancePassedToDestroy() {
            return this.instancePassedToDestroy;
        }

        public CreationalContext<T> getCreationalContextPassedToDestroy() {
            return this.creationalContextPassedToDestroy;
        }
    }
}

