/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.tck.porting;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Context;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.cdi.tck.spi.Contexts;

public class ContextsImpl
implements Contexts<Context> {
    private final Map<Context, InjectableContext.ContextState> contextStateMap = new ConcurrentHashMap<Context, InjectableContext.ContextState>();

    public void setActive(Context context) {
        if (context.isActive()) {
            return;
        }
        if (context instanceof ManagedContext) {
            ManagedContext managed = (ManagedContext)context;
            managed.activate(this.contextStateMap.remove(context));
        }
    }

    public void setInactive(Context context) {
        if (!context.isActive()) {
            return;
        }
        if (context instanceof ManagedContext) {
            ManagedContext managed = (ManagedContext)context;
            this.contextStateMap.put(context, managed.getState());
            managed.deactivate();
        }
    }

    public Context getRequestContext() {
        return Arc.container().requestContext();
    }

    public Context getDependentContext() {
        return Arc.container().getActiveContext(Dependent.class);
    }

    public void destroyContext(Context context) {
        ((InjectableContext)context).destroy();
    }
}

