/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.tck.porting;

import io.quarkus.arc.impl.CreationalContextImpl;
import jakarta.enterprise.context.spi.Contextual;
import org.jboss.cdi.tck.spi.CreationalContexts;

public class CreationalContextsImpl
implements CreationalContexts {
    public <T> CreationalContexts.Inspectable<T> create(Contextual<T> contextual) {
        return new InspectableImpl<T>(contextual);
    }

    static class InspectableImpl<T>
    extends CreationalContextImpl<T>
    implements CreationalContexts.Inspectable<T> {
        private boolean pushCalled = false;
        private Object lastPushed = null;
        private boolean releaseCalled = false;

        public InspectableImpl(Contextual<T> contextual) {
            super(contextual);
        }

        public void push(T incompleteInstance) {
            super.push(incompleteInstance);
            this.pushCalled = true;
            this.lastPushed = incompleteInstance;
        }

        public void release() {
            super.release();
            this.releaseCalled = true;
        }

        public boolean isPushCalled() {
            return this.pushCalled;
        }

        public Object getLastBeanPushed() {
            return this.lastPushed;
        }

        public boolean isReleaseCalled() {
            return this.releaseCalled;
        }
    }
}

