/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.opensearch.client.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.opensearch.OpenSearchConfig;
import io.quarkiverse.opensearch.SSLContextHelper;
import io.quarkiverse.opensearch.client.AwsSdk2TransportOptionsCallback;
import io.quarkiverse.opensearch.client.OpenSearchTransportConfig;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.vertx.core.spi.VertxThreadFactory;
import jakarta.enterprise.inject.Instance;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.util.Timeout;
import org.jboss.logging.Logger;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.transport.aws.AwsSdk2Transport;
import org.opensearch.client.transport.aws.AwsSdk2TransportOptions;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Transport;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5TransportBuilder;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;

public final class OpenSearchTransportHelper {
    private static final VertxThreadFactory VERTX_THREAD_FACTORY = VertxThreadFactory.INSTANCE;
    private static final Logger LOG = Logger.getLogger(OpenSearchTransportHelper.class);

    private OpenSearchTransportHelper() {
    }

    public static ApacheHttpClient5Transport createApacheHttpClient5Transport(final OpenSearchConfig config, Instance<ObjectMapper> objectMappers) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException, IOException {
        ArrayList<HttpHost> list = new ArrayList<HttpHost>();
        for (String s : config.hosts().orElse(List.of("127.0.0.1:9200"))) {
            String[] h = s.split(":");
            HttpHost apply = new HttpHost(config.protocol(), h[0], Integer.valueOf(h[1]).intValue());
            list.add(apply);
        }
        HttpHost[] hosts = list.toArray(new HttpHost[0]);
        ApacheHttpClient5TransportBuilder builder = ApacheHttpClient5TransportBuilder.builder((HttpHost[])hosts);
        ObjectMapper objectMapper = objectMappers.stream().findFirst().orElse(new ObjectMapper().findAndRegisterModules());
        builder.setMapper((JsonpMapper)new JacksonJsonpMapper(objectMapper));
        SSLContext sslContext = SSLContextHelper.createSSLContext((OpenSearchConfig)config);
        builder.setHttpClientConfigCallback(httpAsyncClientBuilder -> {
            ClientTlsStrategyBuilder tlsStrategyBuilder = ClientTlsStrategyBuilder.create().setSslContext(sslContext);
            if (!config.sslVerifyHostname() || !config.sslVerify()) {
                tlsStrategyBuilder.setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            TlsStrategy tlsStrategy = tlsStrategyBuilder.build();
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.of((Duration)config.connectionTimeout())).setSocketTimeout(Timeout.of((Duration)config.socketTimeout())).build();
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).setMaxConnPerRoute(config.maxConnectionsPerRoute()).setMaxConnTotal(config.maxConnections()).setDefaultConnectionConfig(connectionConfig).build();
            if (config.username().isPresent() && config.password().isPresent()) {
                if (!"https".equalsIgnoreCase(config.protocol())) {
                    LOG.warn((Object)"Using Basic authentication in HTTP implies sending plain text passwords over the wire, use the HTTPS protocol instead.");
                }
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials((String)config.username().get(), ((String)config.password().get()).toCharArray()));
                httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            HttpAsyncClientBuilder result = httpAsyncClientBuilder.setConnectionManager((AsyncClientConnectionManager)connectionManager);
            if (VERTX_THREAD_FACTORY != null) {
                result.setThreadFactory(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        return VERTX_THREAD_FACTORY.newVertxThread(r, "HttpClient5OpenSearchTransport", true, config.threadTimeout().getSeconds(), TimeUnit.SECONDS);
                    }
                });
            }
            Iterable httpClientConfigCallbackHandles = Arc.container().select(ApacheHttpClient5TransportBuilder.HttpClientConfigCallback.class, new Annotation[]{new OpenSearchTransportConfig.Literal()}).handles();
            for (InstanceHandle handle : httpClientConfigCallbackHandles) {
                result = ((ApacheHttpClient5TransportBuilder.HttpClientConfigCallback)handle.get()).customizeHttpClient(result);
                handle.close();
            }
            return result;
        });
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            RequestConfig.Builder result = requestConfigBuilder;
            Iterable requestConfigBuilderHandles = Arc.container().select(ApacheHttpClient5TransportBuilder.RequestConfigCallback.class, new Annotation[]{new OpenSearchTransportConfig.Literal()}).handles();
            for (InstanceHandle handle : requestConfigBuilderHandles) {
                result = ((ApacheHttpClient5TransportBuilder.RequestConfigCallback)handle.get()).customizeRequestConfig(result);
                handle.close();
            }
            return result;
        });
        return builder.build();
    }

    public static AwsSdk2Transport createAwsSdk2Transport(OpenSearchConfig config, Instance<ObjectMapper> objectMappers) {
        SdkAsyncHttpClient nettyHttpClient = NettyNioAsyncHttpClient.create();
        AwsSdk2TransportOptions.Builder options = AwsSdk2TransportOptions.builder();
        ObjectMapper objectMapper = objectMappers.stream().findFirst().orElse(new ObjectMapper().findAndRegisterModules());
        options.setMapper((JsonpMapper)new JacksonJsonpMapper(objectMapper));
        if (config.accessKeyId().isPresent() && config.secretAccessKey().isPresent()) {
            options.setCredentials((AwsCredentialsProvider)AwsCredentialsProviderChain.of((AwsCredentialsProvider[])new AwsCredentialsProvider[]{StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)((String)config.accessKeyId().get()), (String)((String)config.secretAccessKey().get()))), DefaultCredentialsProvider.create()}));
        } else {
            options.setCredentials((AwsCredentialsProvider)DefaultCredentialsProvider.create());
        }
        Iterable handles = Arc.container().select(AwsSdk2TransportOptionsCallback.class, new Annotation[]{new OpenSearchTransportConfig.Literal()}).handles();
        for (InstanceHandle handle : handles) {
            options = ((AwsSdk2TransportOptionsCallback)handle.get()).customize(options);
            handle.close();
        }
        return new AwsSdk2Transport(nettyHttpClient, config.hosts().orElse(List.of("")).get(0), (String)config.awsService().get(), Region.of((String)config.awsRegion()), options.build());
    }
}

