/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.providers;

import io.quarkiverse.openapi.generator.providers.UrlPatternMatcher;
import java.util.Objects;

public final class OperationAuthInfo {
    private String operationId = "";
    private String path;
    private String httpMethod;
    private UrlPatternMatcher pathMatcher;

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getPath() {
        return this.path;
    }

    public boolean matchPath(String requestPath) {
        if (this.pathMatcher == null) {
            throw new IllegalStateException("PathMatcher hasn't been initialized for operation " + this.operationId + " set it's path first before trying to match paths.");
        }
        return this.pathMatcher.matches(requestPath);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationAuthInfo that = (OperationAuthInfo)o;
        return this.operationId.equals(that.operationId) && this.path.equals(that.path) && this.httpMethod.equals(that.httpMethod);
    }

    public int hashCode() {
        return Objects.hash(this.operationId, this.path, this.httpMethod);
    }

    public static final class Builder {
        private final OperationAuthInfo operationAuthInfo = new OperationAuthInfo();

        public Builder withId(String operationId) {
            this.operationAuthInfo.operationId = operationId;
            return this;
        }

        public Builder withPath(String path) {
            this.operationAuthInfo.pathMatcher = new UrlPatternMatcher(path);
            this.operationAuthInfo.path = path;
            return this;
        }

        public Builder withMethod(String method) {
            this.operationAuthInfo.httpMethod = method;
            return this;
        }

        public OperationAuthInfo build() {
            return this.operationAuthInfo;
        }
    }
}

