/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.providers;

import io.quarkiverse.openapi.generator.OpenApiGeneratorConfig;
import io.quarkiverse.openapi.generator.providers.AbstractAuthProvider;
import io.quarkiverse.openapi.generator.providers.AuthUtils;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;

public class BearerAuthenticationProvider
extends AbstractAuthProvider {
    static final String BEARER_TOKEN = "bearer-token";
    private final String scheme;

    public BearerAuthenticationProvider(String openApiSpecId, String name, String scheme, OpenApiGeneratorConfig generatorConfig) {
        super(generatorConfig);
        this.init(name, openApiSpecId);
        this.scheme = scheme;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        String bearerToken;
        if (this.isTokenPropagation()) {
            bearerToken = this.getTokenForPropagation((MultivaluedMap<String, Object>)requestContext.getHeaders());
            bearerToken = BearerAuthenticationProvider.sanitizeBearerToken(bearerToken);
        } else {
            bearerToken = this.getBearerToken();
        }
        requestContext.getHeaders().add((Object)"Authorization", (Object)AuthUtils.authTokenOrBearer(this.scheme, bearerToken));
    }

    private String getBearerToken() {
        return this.getAuthConfigParam(BEARER_TOKEN, "");
    }
}

