/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.providers;

import io.quarkiverse.openapi.generator.OpenApiGeneratorConfig;
import io.quarkiverse.openapi.generator.OpenApiGeneratorException;
import io.quarkiverse.openapi.generator.providers.AbstractAuthProvider;
import io.quarkiverse.openapi.generator.providers.ApiKeyIn;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeyAuthenticationProvider
extends AbstractAuthProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiKeyAuthenticationProvider.class);
    static final String API_KEY = "api-key";
    static final String USE_AUTHORIZATION_HEADER_VALUE = "use-authorization-header-value";
    private final ApiKeyIn apiKeyIn;
    private final String apiKeyName;

    public ApiKeyAuthenticationProvider(String openApiSpecId, String name, ApiKeyIn apiKeyIn, String apiKeyName, OpenApiGeneratorConfig generatorConfig) {
        super(generatorConfig);
        this.init(name, openApiSpecId);
        this.apiKeyIn = apiKeyIn;
        this.apiKeyName = apiKeyName;
        this.validateConfig();
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        switch (this.apiKeyIn) {
            case query: {
                requestContext.setUri(UriBuilder.fromUri((URI)requestContext.getUri()).queryParam(this.apiKeyName, new Object[]{this.getApiKey()}).build(new Object[0]));
                break;
            }
            case cookie: {
                requestContext.getCookies().put(this.apiKeyName, ((Cookie.Builder)new Cookie.Builder(this.apiKeyName).value(this.getApiKey())).build());
                break;
            }
            case header: {
                if (requestContext.getHeaderString("Authorization") != null && !requestContext.getHeaderString("Authorization").isEmpty() && this.isUseAuthorizationHeaderValue()) {
                    requestContext.getHeaders().putSingle((Object)this.apiKeyName, (Object)requestContext.getHeaderString("Authorization"));
                    break;
                }
                requestContext.getHeaders().putSingle((Object)this.apiKeyName, (Object)this.getApiKey());
            }
        }
    }

    private String getApiKey() {
        String key = this.getAuthConfigParam(API_KEY, "");
        if (key.isEmpty()) {
            LOGGER.warn("configured api-key property (see application.properties) is empty. hint: configure it.");
        }
        return key;
    }

    private boolean isUseAuthorizationHeaderValue() {
        String value = this.getAuthConfigParam(USE_AUTHORIZATION_HEADER_VALUE, "true");
        return "true".equals(value);
    }

    private void validateConfig() {
        if (this.isTokenPropagation()) {
            throw new OpenApiGeneratorException("Token propagation is not admitted for the OpenApi securitySchemes of \"type\": \"apiKey\". A potential source of the problem might be that the configuration property " + this.getCanonicalAuthConfigPropertyName("token-propagation") + " was set with the value true in your application, please check your configuration.");
        }
    }
}

