/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.providers;

import io.quarkiverse.openapi.generator.OpenApiGeneratorConfig;
import io.quarkiverse.openapi.generator.providers.AbstractAuthProvider;
import io.quarkiverse.openapi.generator.providers.AbstractAuthenticationPropagationHeadersFactory;
import io.quarkiverse.openapi.generator.providers.AuthProvider;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractCompositeAuthenticationProvider
implements ClientRequestFilter {
    private final List<AuthProvider> authProviders = new ArrayList<AuthProvider>();

    public final void addAuthenticationProvider(AuthProvider authProvider) {
        this.authProviders.add(authProvider);
    }

    public final List<AuthProvider> getAuthenticationProviders() {
        return this.authProviders;
    }

    public final void filter(ClientRequestContext requestContext) throws IOException {
        HashSet<String> removableHeaderPrefix = new HashSet<String>();
        for (AuthProvider authProvider : this.authProviders) {
            if (authProvider instanceof AbstractAuthProvider) {
                removableHeaderPrefix.add(AbstractAuthenticationPropagationHeadersFactory.propagationHeaderNamePrefix(((AbstractAuthProvider)authProvider).getOpenApiSpecId()));
            }
            if (!this.canFilter(authProvider, requestContext)) continue;
            authProvider.filter(requestContext);
        }
        this.removeAuthenticationTemporalHeaders(requestContext, removableHeaderPrefix);
    }

    private boolean canFilter(AuthProvider authProvider, ClientRequestContext requestContext) {
        return authProvider.operationsToFilter().stream().anyMatch(o -> o.getHttpMethod().equals(requestContext.getMethod()) && o.matchPath(requestContext.getUri().getPath()));
    }

    protected static String sanitizeAuthName(String schemeName) {
        return OpenApiGeneratorConfig.getSanitizedSecuritySchemeName(schemeName);
    }

    private void removeAuthenticationTemporalHeaders(ClientRequestContext requestContext, Set<String> removableHeaderPrefix) {
        HashSet headersToRemove = new HashSet();
        requestContext.getHeaders().keySet().forEach(headerName -> {
            boolean remove = removableHeaderPrefix.stream().anyMatch(headerName::startsWith);
            if (remove) {
                headersToRemove.add(headerName);
            }
        });
        headersToRemove.forEach(headerToRemove -> requestContext.getHeaders().remove(headerToRemove));
    }
}

