/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.providers;

import io.quarkiverse.openapi.generator.OpenApiGeneratorConfig;
import io.quarkiverse.openapi.generator.OpenApiGeneratorException;
import io.quarkiverse.openapi.generator.providers.AbstractAuthProvider;
import io.quarkiverse.openapi.generator.providers.AuthUtils;
import java.io.IOException;
import javax.ws.rs.client.ClientRequestContext;

public class BasicAuthenticationProvider
extends AbstractAuthProvider {
    static final String USER_NAME = "username";
    static final String PASSWORD = "password";

    public BasicAuthenticationProvider(String openApiSpecId, String name, OpenApiGeneratorConfig generatorConfig) {
        super(generatorConfig);
        this.init(name, openApiSpecId);
        this.validateConfig();
    }

    private String getUsername() {
        return this.getAuthConfigParam(USER_NAME, "");
    }

    private String getPassword() {
        return this.getAuthConfigParam(PASSWORD, "");
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        requestContext.getHeaders().add((Object)"Authorization", (Object)AuthUtils.basicAuthAccessToken(this.getUsername(), this.getPassword()));
    }

    private void validateConfig() {
        if (this.isTokenPropagation()) {
            throw new OpenApiGeneratorException("Token propagation is not admitted for the OpenApi securitySchemes of \"type\": \"http\", \"scheme\": \"basic\". A potential source of the problem might be that the configuration property " + this.getCanonicalAuthConfigPropertyName("token-propagation") + " was set with the value true in your application, please check your configuration.");
        }
    }
}

