/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.deployment.wrapper;

import io.quarkiverse.openapi.generator.deployment.CodegenConfig;
import io.quarkiverse.openapi.generator.deployment.wrapper.QuarkusCodegenConfigurator;
import io.smallrye.config.common.utils.StringUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.config.GlobalSettings;

public abstract class OpenApiClientGeneratorWrapper {
    public static final String VERBOSE = "verbose";
    private static final String ONCE_LOGGER = "org.openapitools.codegen.utils.oncelogger.enabled";
    public static final String DEFAULT_SECURITY_SCHEME = "defaultSecurityScheme";
    public static final String SUPPORTS_ADDITIONAL_PROPERTIES_AS_ATTRIBUTE = "supportsAdditionalPropertiesWithComposedSchema";
    private static final Map<String, String> defaultTypeMappings = Map.of("date", "LocalDate", "DateTime", "OffsetDateTime");
    private static final Map<String, String> defaultImportMappings = Map.of("LocalDate", "java.time.LocalDate", "OffsetDateTime", "java.time.OffsetDateTime");
    private final QuarkusCodegenConfigurator configurator;
    private final DefaultGenerator generator;
    private String basePackage = "";
    private String apiPackage = "";
    private String modelPackage = "";

    OpenApiClientGeneratorWrapper(QuarkusCodegenConfigurator configurator, Path specFilePath, Path outputDir, boolean verbose, boolean validateSpec) {
        GlobalSettings.setProperty((String)"apiDocs", (String)Boolean.FALSE.toString());
        GlobalSettings.setProperty((String)"apiTests", (String)Boolean.FALSE.toString());
        GlobalSettings.setProperty((String)"modelTests", (String)Boolean.FALSE.toString());
        GlobalSettings.setProperty((String)"modelDocs", (String)Boolean.FALSE.toString());
        GlobalSettings.setProperty((String)"apis", (String)"");
        GlobalSettings.setProperty((String)"models", (String)"");
        GlobalSettings.setProperty((String)"supportingFiles", (String)"");
        GlobalSettings.setProperty((String)VERBOSE, (String)String.valueOf(verbose));
        GlobalSettings.setProperty((String)ONCE_LOGGER, (String)(verbose ? Boolean.FALSE.toString() : Boolean.TRUE.toString()));
        this.configurator = configurator;
        this.configurator.setInputSpec(specFilePath.toString());
        this.configurator.setOutputDir(outputDir.toString());
        this.configurator.addAdditionalProperty("quarkus-generator", Collections.singletonMap("openApiSpecId", CodegenConfig.getSanitizedFileName(specFilePath)));
        this.configurator.addAdditionalProperty("openApiNullable", false);
        this.configurator.setValidateSpec(validateSpec);
        defaultTypeMappings.forEach((arg_0, arg_1) -> ((QuarkusCodegenConfigurator)this.configurator).addTypeMapping(arg_0, arg_1));
        defaultImportMappings.forEach((arg_0, arg_1) -> ((QuarkusCodegenConfigurator)this.configurator).addImportMapping(arg_0, arg_1));
        this.generator = new DefaultGenerator();
    }

    public OpenApiClientGeneratorWrapper withApiPackage(String pkg) {
        this.apiPackage = pkg;
        return this;
    }

    public OpenApiClientGeneratorWrapper withModelPackage(String pkg) {
        this.modelPackage = pkg;
        return this;
    }

    public OpenApiClientGeneratorWrapper withCircuitBreakerConfig(Map<String, List<String>> config) {
        if (config != null) {
            this.configurator.addAdditionalProperty("circuit-breaker", config);
        }
        return this;
    }

    public OpenApiClientGeneratorWrapper withClassesCodeGenConfig(Map<String, Object> config) {
        if (config != null) {
            this.configurator.addAdditionalProperty("classes-codegen", config);
        }
        return this;
    }

    public OpenApiClientGeneratorWrapper withMutiny(Boolean config) {
        if (config != null) {
            this.configurator.addAdditionalProperty("mutiny", config);
        }
        return this;
    }

    public OpenApiClientGeneratorWrapper withSkipFormModelConfig(String skipFormModel) {
        GlobalSettings.setProperty((String)"skipFormModel", (String)skipFormModel);
        return this;
    }

    public OpenApiClientGeneratorWrapper withTypeMappings(Map<String, String> typeMappings) {
        typeMappings.forEach((arg_0, arg_1) -> ((QuarkusCodegenConfigurator)this.configurator).addTypeMapping(arg_0, arg_1));
        return this;
    }

    public OpenApiClientGeneratorWrapper withReturnResponse(Boolean returnResponse) {
        this.configurator.addAdditionalProperty("return-response", returnResponse);
        return this;
    }

    public OpenApiClientGeneratorWrapper withEnabledSecurityGeneration(Boolean enableSecurityGeneration) {
        this.configurator.addAdditionalProperty("enable-security-generation", enableSecurityGeneration);
        return this;
    }

    public OpenApiClientGeneratorWrapper withImportMappings(Map<String, String> typeMappings) {
        typeMappings.forEach((arg_0, arg_1) -> ((QuarkusCodegenConfigurator)this.configurator).addImportMapping(arg_0, arg_1));
        return this;
    }

    public OpenApiClientGeneratorWrapper withOpenApiNormalizer(Map<String, String> openApiNormalizer) {
        this.configurator.setOpenAPINormalizer(openApiNormalizer);
        return this;
    }

    public OpenApiClientGeneratorWrapper withAdditionalModelTypeAnnotationsConfig(String additionalModelTypeAnnotations) {
        if (additionalModelTypeAnnotations != null) {
            this.configurator.addAdditionalProperty("additionalModelTypeAnnotations", additionalModelTypeAnnotations);
        }
        return this;
    }

    public OpenApiClientGeneratorWrapper withAdditionalApiTypeAnnotationsConfig(String additionalApiTypeAnnotations) {
        if (additionalApiTypeAnnotations != null) {
            this.configurator.addAdditionalProperty("additionalApiTypeAnnotations", additionalApiTypeAnnotations.split(";"));
        }
        return this;
    }

    public void withTemplateDir(Path templateDir) {
        this.configurator.addAdditionalProperty("templateDir", templateDir.toString());
    }

    public OpenApiClientGeneratorWrapper withGeneratePartFilenameConfig(Boolean generatePartFilename) {
        this.configurator.addAdditionalProperty("generate-part-filename", generatePartFilename);
        return this;
    }

    public OpenApiClientGeneratorWrapper withPartFilenameValueConfig(String partFilenameValue) {
        this.configurator.addAdditionalProperty("part-filename-value", partFilenameValue);
        return this;
    }

    public OpenApiClientGeneratorWrapper withUseFieldNameInPartFilenameConfig(Boolean useFieldNameInPartFilename) {
        this.configurator.addAdditionalProperty("use-field-name-in-part-filename", useFieldNameInPartFilename);
        return this;
    }

    public OpenApiClientGeneratorWrapper withApiNameSuffix(String apiNameSuffix) {
        this.configurator.setApiNameSuffix(apiNameSuffix);
        return this;
    }

    public OpenApiClientGeneratorWrapper withModelNameSuffix(String modelNameSuffix) {
        this.configurator.setModelNameSuffix(modelNameSuffix);
        return this;
    }

    public OpenApiClientGeneratorWrapper withModelNamePrefix(String modelNamePrefix) {
        this.configurator.setModelNamePrefix(modelNamePrefix);
        return this;
    }

    public List<File> generate(String basePackage) {
        this.basePackage = basePackage;
        this.consolidatePackageNames();
        return this.generator.opts(this.configurator.toClientOptInput()).generate();
    }

    private void consolidatePackageNames() {
        Objects.requireNonNull(this.basePackage);
        if (this.basePackage.isEmpty()) {
            throw new IllegalArgumentException("basePackage must be a non-empty String");
        }
        if (this.apiPackage.isEmpty()) {
            this.apiPackage = CodegenConfig.resolveApiPackage(this.basePackage);
        }
        if (this.modelPackage.isEmpty()) {
            this.modelPackage = CodegenConfig.resolveModelPackage(this.basePackage);
        }
        this.configurator.setPackageName(this.basePackage);
        this.configurator.setApiPackage(this.apiPackage);
        this.configurator.setModelPackage(this.modelPackage);
        this.configurator.setInvokerPackage(this.apiPackage);
    }

    public void withConfigKey(String config) {
        if (config != null && !config.isBlank()) {
            this.configurator.addAdditionalProperty("configKey", StringUtil.replaceNonAlphanumericByUnderscores((String)config));
        }
    }

    public void withAdditionalPropertiesAsAttribute(Boolean enable) {
        this.configurator.addAdditionalProperty("additionalPropertiesAsAttribute", Optional.ofNullable(enable).orElse(Boolean.FALSE));
    }
}

