/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.deployment.codegen;

import io.quarkiverse.openapi.generator.deployment.CodegenConfig;
import io.smallrye.config.PropertiesConfigSource;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class SpecInputModel {
    private final InputStream inputStream;
    private final String filename;
    private final Map<String, String> codegenProperties = new HashMap<String, String>();

    public SpecInputModel(String filename, InputStream inputStream) {
        Objects.requireNonNull(inputStream, "InputStream can't be null");
        Objects.requireNonNull(filename, "File name can't be null");
        this.inputStream = inputStream;
        this.filename = filename;
    }

    public SpecInputModel(String filename, InputStream inputStream, String basePackageName) {
        this(filename, inputStream);
        this.codegenProperties.put(CodegenConfig.getSpecConfigName(CodegenConfig.ConfigName.BASE_PACKAGE, Path.of(filename, new String[0])), basePackageName);
    }

    public SpecInputModel(String filename, InputStream inputStream, String basePackageName, String apiNameSuffix, String modelNameSuffix, String modelNamePrefix) {
        this(filename, inputStream, basePackageName);
        Path openApiFilePath = Path.of(filename, new String[0]);
        this.codegenProperties.put(CodegenConfig.getSpecConfigName(CodegenConfig.ConfigName.API_NAME_SUFFIX, openApiFilePath), apiNameSuffix);
        this.codegenProperties.put(CodegenConfig.getSpecConfigName(CodegenConfig.ConfigName.MODEL_NAME_SUFFIX, openApiFilePath), modelNameSuffix);
        this.codegenProperties.put(CodegenConfig.getSpecConfigName(CodegenConfig.ConfigName.MODEL_NAME_PREFIX, openApiFilePath), modelNamePrefix);
    }

    public String getFileName() {
        return this.filename;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public ConfigSource getConfigSource() {
        return new PropertiesConfigSource(this.codegenProperties, "properties", 0);
    }

    public String toString() {
        return "SpecInputModel{name='" + this.filename + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecInputModel that = (SpecInputModel)o;
        return this.inputStream.equals(that.inputStream) && this.filename.equals(that.filename);
    }

    public int hashCode() {
        return Objects.hash(this.inputStream, this.filename);
    }
}

