/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.deployment.codegen;

import io.quarkiverse.openapi.generator.deployment.codegen.OpenApiGeneratorCodeGenBase;
import io.quarkiverse.openapi.generator.deployment.codegen.OpenApiSpecInputProvider;
import io.quarkiverse.openapi.generator.deployment.codegen.SpecInputModel;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiGeneratorStreamCodeGen
extends OpenApiGeneratorCodeGenBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiGeneratorStreamCodeGen.class);
    private final List<OpenApiSpecInputProvider> providers;

    public OpenApiGeneratorStreamCodeGen() {
        ServiceLoader<OpenApiSpecInputProvider> loader = ServiceLoader.load(OpenApiSpecInputProvider.class);
        this.providers = loader.stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
        LOGGER.debug("Loaded {} OpenApiSpecInputProviders", this.providers);
    }

    public String providerId() {
        return "open-api-stream";
    }

    public String inputExtension() {
        return ".yaml";
    }

    @Override
    public String inputDirectory() {
        return "openapi";
    }

    @Override
    public boolean trigger(CodeGenContext context) throws CodeGenException {
        Path outDir = context.outDir();
        boolean generated = false;
        boolean isRestEasyReactive = this.isRestEasyReactive(context);
        for (OpenApiSpecInputProvider provider : this.providers) {
            for (SpecInputModel inputModel : provider.read(context)) {
                LOGGER.debug("Processing OpenAPI spec input model {}", (Object)inputModel);
                if (inputModel == null) {
                    throw new CodeGenException("SpecInputModel from provider " + provider + " is null");
                }
                try {
                    Path openApiFilePath = Paths.get(outDir.toString(), inputModel.getFileName());
                    Files.createDirectories(openApiFilePath.getParent(), new FileAttribute[0]);
                    ReadableByteChannel inChannel = Channels.newChannel(inputModel.getInputStream());
                    try {
                        FileChannel outChannel = FileChannel.open(openApiFilePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                        try {
                            outChannel.transferFrom(inChannel, 0L, Integer.MAX_VALUE);
                            LOGGER.debug("Saved OpenAPI spec input model in {}", (Object)openApiFilePath);
                            this.generate(this.mergeConfig(context, inputModel), openApiFilePath, outDir, context.workDir().resolve("classes").resolve("templates"), isRestEasyReactive);
                            generated = true;
                        }
                        finally {
                            if (outChannel == null) continue;
                            outChannel.close();
                        }
                    }
                    finally {
                        if (inChannel == null) continue;
                        inChannel.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to save InputStream from provider " + provider + " into location ", e);
                }
            }
        }
        return generated;
    }

    private Config mergeConfig(CodeGenContext context, SpecInputModel inputModel) {
        ArrayList sources = new ArrayList();
        context.config().getConfigSources().forEach(sources::add);
        return new SmallRyeConfigBuilder().withSources(new ConfigSource[]{inputModel.getConfigSource()}).withSources(sources).build();
    }

    @Override
    public boolean shouldRun(Path sourceDir, Config config) {
        return !this.providers.isEmpty();
    }
}

