/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.deployment.codegen;

import io.quarkiverse.openapi.generator.deployment.CodegenConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;

public final class ClassCodegenConfigParser {
    public static Map<String, Object> parse(Config config, String basePackage) {
        List<String> modelProperties = ClassCodegenConfigParser.filterPropertyNames(config.getPropertyNames(), CodegenConfig.resolveModelPackage(basePackage));
        List<String> apiProperties = ClassCodegenConfigParser.filterPropertyNames(config.getPropertyNames(), CodegenConfig.resolveApiPackage(basePackage));
        modelProperties.addAll(apiProperties);
        HashMap<String, Object> modelConfig = new HashMap<String, Object>();
        modelProperties.forEach(m -> modelConfig.put((String)m, config.getValue(m, String.class)));
        return modelConfig;
    }

    private static List<String> filterPropertyNames(Iterable<String> propertyNames, String findPackage) {
        return StreamSupport.stream(propertyNames.spliterator(), false).filter(propertyName -> propertyName.startsWith(findPackage)).collect(Collectors.toList());
    }
}

