/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.deployment;

import io.quarkiverse.openapi.generator.deployment.GlobalCodegenConfig;
import io.quarkiverse.openapi.generator.deployment.SpecItemConfig;
import io.quarkiverse.openapi.generator.deployment.codegen.OpenApiGeneratorOutputPaths;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.common.utils.StringUtil;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ConfigRoot(name="openapi-generator.codegen", phase=ConfigPhase.BUILD_TIME)
public class CodegenConfig
extends GlobalCodegenConfig {
    static final String CODEGEN_TIME_CONFIG_PREFIX = "openapi-generator.codegen";
    public static final String API_PKG_SUFFIX = ".api";
    public static final String MODEL_PKG_SUFFIX = ".model";
    static final String BUILD_TIME_GLOBAL_PREFIX_FORMAT = "quarkus.openapi-generator.codegen.%s";
    static final String BUILD_TIME_SPEC_PREFIX_FORMAT = "quarkus.openapi-generator.codegen.spec.%s";
    public static final List<String> SUPPORTED_CONFIGURATIONS = Arrays.stream(ConfigName.values()).map(cn -> cn.name).collect(Collectors.toList());
    @ConfigItem(name="spec")
    public Map<String, SpecItemConfig> specItem;

    public static String resolveApiPackage(String basePackage) {
        return String.format("%s%s", basePackage, API_PKG_SUFFIX);
    }

    public static String resolveModelPackage(String basePackage) {
        return String.format("%s%s", basePackage, MODEL_PKG_SUFFIX);
    }

    public static String getGlobalConfigName(ConfigName configName) {
        return String.format(BUILD_TIME_GLOBAL_PREFIX_FORMAT, configName.name);
    }

    public static String getSpecConfigName(ConfigName configName, Path openApiFilePath) {
        return String.format("%s.%s", CodegenConfig.getBuildTimeSpecPropertyPrefix(openApiFilePath), configName.name);
    }

    public static String getSpecConfigNameByConfigKey(String configKey, ConfigName configName) {
        String buildTimeSpecPropertyPrefix = String.format(BUILD_TIME_SPEC_PREFIX_FORMAT, configKey);
        return String.format("%s.%s", buildTimeSpecPropertyPrefix, configName.name);
    }

    public static String getBuildTimeSpecPropertyPrefix(Path openApiFilePath) {
        return String.format(BUILD_TIME_SPEC_PREFIX_FORMAT, CodegenConfig.getSanitizedFileName(openApiFilePath));
    }

    public static String getSanitizedFileName(Path openApiFilePath) {
        return StringUtil.replaceNonAlphanumericByUnderscores((String)OpenApiGeneratorOutputPaths.getRelativePath(openApiFilePath).toString());
    }

    public static enum ConfigName {
        VERBOSE("verbose"),
        INPUT_BASE_DIR("input-base-dir"),
        INCLUDE("include"),
        EXCLUDE("exclude"),
        VALIDATE_SPEC("validateSpec"),
        DEFAULT_SECURITY_SCHEME("default-security-scheme"),
        BASE_PACKAGE("base-package"),
        API_NAME_SUFFIX("api-name-suffix"),
        MODEL_NAME_SUFFIX("model-name-suffix"),
        MODEL_NAME_PREFIX("model-name-prefix"),
        SKIP_FORM_MODEL("skip-form-model"),
        MUTINY("mutiny"),
        ADDITIONAL_MODEL_TYPE_ANNOTATIONS("additional-model-type-annotations"),
        ADDITIONAL_API_TYPE_ANNOTATIONS("additional-api-type-annotations"),
        TYPE_MAPPINGS("type-mappings"),
        IMPORT_MAPPINGS("import-mappings"),
        NORMALIZER("open-api-normalizer"),
        RETURN_RESPONSE("return-response"),
        ENABLE_SECURITY_GENERATION("enable-security-generation"),
        CONFIG_KEY("config-key"),
        GENERATE_PART_FILENAME("generate-part-filename"),
        PART_FILENAME_VALUE("part-filename-value"),
        USE_FIELD_NAME_IN_PART_FILENAME("use-field-name-in-part-filename"),
        ADDITIONAL_PROPERTIES_AS_ATTRIBUTE("additional-properties-as-attribute");

        private final String name;

        private ConfigName(String name) {
            this.name = name;
        }
    }
}

