/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.deployment.codegen;

import io.quarkiverse.openapi.generator.deployment.CodegenConfig;
import io.quarkiverse.openapi.generator.deployment.circuitbreaker.CircuitBreakerConfigurationParser;
import io.quarkiverse.openapi.generator.deployment.codegen.ClassCodegenConfigParser;
import io.quarkiverse.openapi.generator.deployment.codegen.OpenApiConfigValidator;
import io.quarkiverse.openapi.generator.deployment.wrapper.OpenApiClassicClientGeneratorWrapper;
import io.quarkiverse.openapi.generator.deployment.wrapper.OpenApiClientGeneratorWrapper;
import io.quarkiverse.openapi.generator.deployment.wrapper.OpenApiReactiveClientGeneratorWrapper;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.smallrye.config.SmallRyeConfig;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.openapitools.codegen.config.GlobalSettings;

public abstract class OpenApiGeneratorCodeGenBase
implements CodeGenProvider {
    static final String YAML = ".yaml";
    static final String YML = ".yml";
    static final String JSON = ".json";
    private static final String DEFAULT_PACKAGE = "org.openapi.quarkus";
    private static final String CONFIG_KEY_PROPERTY = "config-key";

    public String inputDirectory() {
        return "openapi";
    }

    public boolean shouldRun(Path sourceDir, Config config) {
        String inputBaseDir = this.getInputBaseDirRelativeToModule(sourceDir, config).orElse(null);
        if (inputBaseDir != null) {
            return Files.isDirectory(Path.of(inputBaseDir, new String[0]), new LinkOption[0]);
        }
        return Files.isDirectory(sourceDir, new LinkOption[0]) || sourceDir.endsWith(Path.of("src", "test", this.inputDirectory()));
    }

    protected boolean isRestEasyReactive(CodeGenContext context) {
        return context.applicationModel().getExtensionCapabilities().stream().flatMap(extensionCapability -> extensionCapability.getProvidesCapabilities().stream()).anyMatch("io.quarkus.rest.client.reactive"::equals);
    }

    public boolean trigger(CodeGenContext context) throws CodeGenException {
        Path outDir = context.outDir();
        this.validateUserConfiguration(context);
        Optional<String> inputBaseDir = this.getInputBaseDirRelativeToModule(context.inputDir(), context.config());
        Path openApiDir = inputBaseDir.map(x$0 -> Path.of(x$0, new String[0])).orElseGet(() -> ((CodeGenContext)context).inputDir());
        List filesToInclude = context.config().getOptionalValues(CodegenConfig.getGlobalConfigName(CodegenConfig.ConfigName.INCLUDE), String.class).orElse(List.of());
        List filesToExclude = context.config().getOptionalValues(CodegenConfig.getGlobalConfigName(CodegenConfig.ConfigName.EXCLUDE), String.class).orElse(List.of());
        if (Files.isDirectory(openApiDir, new LinkOption[0])) {
            boolean isRestEasyReactive = this.isRestEasyReactive(context);
            if (isRestEasyReactive) {
                if (!this.isJacksonReactiveClientPresent(context)) {
                    throw new CodeGenException("You need to add io.quarkus:quarkus-rest-client-reactive-jackson to your dependencies.");
                }
            } else if (!this.isJacksonClassicClientPresent(context)) {
                throw new CodeGenException("You need to add io.quarkus:quarkus-rest-client-jackson to your dependencies.");
            }
            try (Stream<Path> openApiFilesPaths = Files.walk(openApiDir, new FileVisitOption[0]);){
                Path templateDir = context.workDir().resolve("classes").resolve("templates");
                openApiFilesPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                    String fileName = path.getFileName().toString();
                    return fileName.endsWith(this.inputExtension()) && !filesToExclude.contains(fileName) && (filesToInclude.isEmpty() || filesToInclude.contains(fileName));
                }).forEach(openApiFilePath -> this.generate(context.config(), (Path)openApiFilePath, outDir, templateDir, isRestEasyReactive));
            }
            catch (IOException e) {
                throw new CodeGenException("Failed to generate java files from OpenApi files in " + openApiDir.toAbsolutePath(), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private void validateUserConfiguration(CodeGenContext context) throws CodeGenException {
        List<String> configurations = StreamSupport.stream(context.config().getPropertyNames().spliterator(), false).collect(Collectors.toList());
        OpenApiConfigValidator.validateInputConfiguration(configurations);
    }

    private boolean isJacksonReactiveClientPresent(CodeGenContext context) {
        return context.applicationModel().getDependencies().stream().anyMatch(this::isJacksonReactiveClient);
    }

    private boolean isJacksonClassicClientPresent(CodeGenContext context) {
        return context.applicationModel().getExtensionCapabilities().stream().flatMap(extensionCapability -> extensionCapability.getProvidesCapabilities().stream()).anyMatch("io.quarkus.resteasy.json.jackson.client"::equals);
    }

    private boolean isJacksonReactiveClient(ResolvedDependency resolvedDependency) {
        return "quarkus-rest-client-reactive-jackson".equals(resolvedDependency.getArtifactId()) && "io.quarkus".equals(resolvedDependency.getGroupId());
    }

    protected void generate(Config config, Path openApiFilePath, Path outDir, Path templateDir, boolean isRestEasyReactive) {
        String basePackage = this.getBasePackage(config, openApiFilePath);
        Boolean verbose = config.getOptionalValue(CodegenConfig.getGlobalConfigName(CodegenConfig.ConfigName.VERBOSE), Boolean.class).orElse(false);
        Boolean validateSpec = config.getOptionalValue(CodegenConfig.getGlobalConfigName(CodegenConfig.ConfigName.VALIDATE_SPEC), Boolean.class).orElse(true);
        GlobalSettings.setProperty((String)"defaultSecurityScheme", (String)config.getOptionalValue(CodegenConfig.getGlobalConfigName(CodegenConfig.ConfigName.DEFAULT_SECURITY_SCHEME), String.class).orElse(""));
        OpenApiClientGeneratorWrapper generator = OpenApiGeneratorCodeGenBase.createGeneratorWrapper(openApiFilePath, outDir, isRestEasyReactive, verbose, validateSpec);
        generator.withTemplateDir(templateDir);
        generator.withClassesCodeGenConfig(ClassCodegenConfigParser.parse(config, basePackage)).withCircuitBreakerConfig(CircuitBreakerConfigurationParser.parse(config));
        this.getApiNameSuffix(config, openApiFilePath).ifPresent(generator::withApiNameSuffix);
        this.getModelNameSuffix(config, openApiFilePath).ifPresent(generator::withModelNameSuffix);
        this.getModelNamePrefix(config, openApiFilePath).ifPresent(generator::withModelNamePrefix);
        this.getValues(config, openApiFilePath, CodegenConfig.ConfigName.MUTINY, Boolean.class).ifPresent(generator::withMutiny);
        this.getValues(config, openApiFilePath, CodegenConfig.ConfigName.SKIP_FORM_MODEL, String.class).ifPresent(generator::withSkipFormModelConfig);
        this.getValues(config, openApiFilePath, CodegenConfig.ConfigName.ADDITIONAL_MODEL_TYPE_ANNOTATIONS, String.class).ifPresent(generator::withAdditionalModelTypeAnnotationsConfig);
        this.getValues(config, openApiFilePath, CodegenConfig.ConfigName.ADDITIONAL_API_TYPE_ANNOTATIONS, String.class).ifPresent(generator::withAdditionalApiTypeAnnotationsConfig);
        OpenApiGeneratorCodeGenBase.getConfigKeyValue(config, openApiFilePath).ifPresentOrElse(generator::withConfigKey, () -> generator.withConfigKey(CodegenConfig.getSanitizedFileName(openApiFilePath)));
        generator.withReturnResponse(this.getValues(config, openApiFilePath, CodegenConfig.ConfigName.RETURN_RESPONSE, Boolean.class).orElse(false));
        generator.withEnabledSecurityGeneration(this.getValues(config, openApiFilePath, CodegenConfig.ConfigName.ENABLE_SECURITY_GENERATION, Boolean.class).orElse(true));
        generator.withGeneratePartFilenameConfig(this.getValues(config, openApiFilePath, CodegenConfig.ConfigName.GENERATE_PART_FILENAME, Boolean.class).orElse(true));
        this.getValues(config, openApiFilePath, CodegenConfig.ConfigName.PART_FILENAME_VALUE, String.class).ifPresent(generator::withPartFilenameValueConfig);
        generator.withUseFieldNameInPartFilenameConfig(this.getValues(config, openApiFilePath, CodegenConfig.ConfigName.USE_FIELD_NAME_IN_PART_FILENAME, Boolean.class).orElse(true));
        SmallRyeConfig smallRyeConfig = (SmallRyeConfig)config.unwrap(SmallRyeConfig.class);
        this.getValues(smallRyeConfig, openApiFilePath, CodegenConfig.ConfigName.TYPE_MAPPINGS, String.class, String.class).ifPresent(generator::withTypeMappings);
        this.getValues(smallRyeConfig, openApiFilePath, CodegenConfig.ConfigName.IMPORT_MAPPINGS, String.class, String.class).ifPresent(generator::withImportMappings);
        this.getValues(smallRyeConfig, openApiFilePath, CodegenConfig.ConfigName.NORMALIZER, String.class, String.class).ifPresent(generator::withOpenApiNormalizer);
        Boolean additionalPropertiesAsAttribute = this.getValues((Config)smallRyeConfig, openApiFilePath, CodegenConfig.ConfigName.ADDITIONAL_PROPERTIES_AS_ATTRIBUTE, Boolean.class).orElse(Boolean.FALSE);
        generator.withAdditionalPropertiesAsAttribute(additionalPropertiesAsAttribute);
        GlobalSettings.setProperty((String)"supportsAdditionalPropertiesWithComposedSchema", (String)additionalPropertiesAsAttribute.toString());
        generator.generate(basePackage);
    }

    private static OpenApiClientGeneratorWrapper createGeneratorWrapper(Path openApiFilePath, Path outDir, boolean isRestEasyReactive, Boolean verbose, Boolean validateSpec) {
        if (isRestEasyReactive) {
            return new OpenApiReactiveClientGeneratorWrapper(openApiFilePath.normalize(), outDir, verbose, validateSpec);
        }
        return new OpenApiClassicClientGeneratorWrapper(openApiFilePath.normalize(), outDir, verbose, validateSpec);
    }

    private String getBasePackage(Config config, Path openApiFilePath) {
        return config.getOptionalValue(CodegenConfig.getSpecConfigName(CodegenConfig.ConfigName.BASE_PACKAGE, openApiFilePath), String.class).orElse(String.format("%s.%s", DEFAULT_PACKAGE, CodegenConfig.getSanitizedFileName(openApiFilePath)));
    }

    private Optional<String> getApiNameSuffix(Config config, Path openApiFilePath) {
        return config.getOptionalValue(CodegenConfig.getSpecConfigName(CodegenConfig.ConfigName.API_NAME_SUFFIX, openApiFilePath), String.class);
    }

    private Optional<String> getModelNameSuffix(Config config, Path openApiFilePath) {
        return config.getOptionalValue(CodegenConfig.getSpecConfigName(CodegenConfig.ConfigName.MODEL_NAME_SUFFIX, openApiFilePath), String.class);
    }

    private Optional<String> getModelNamePrefix(Config config, Path openApiFilePath) {
        return config.getOptionalValue(CodegenConfig.getSpecConfigName(CodegenConfig.ConfigName.MODEL_NAME_PREFIX, openApiFilePath), String.class);
    }

    private Optional<String> getInputBaseDirRelativeToModule(Path sourceDir, Config config) {
        return config.getOptionalValue(CodegenConfig.getGlobalConfigName(CodegenConfig.ConfigName.INPUT_BASE_DIR), String.class).map(inputBaseDir -> {
            int srcIndex = sourceDir.toString().lastIndexOf("src");
            return srcIndex < 0 ? null : sourceDir.toString().substring(0, srcIndex) + inputBaseDir;
        });
    }

    private <T> Optional<T> getValues(Config config, Path openApiFilePath, CodegenConfig.ConfigName configName, Class<T> propertyType) {
        return this.getConfigKeyValues(config, openApiFilePath, configName, propertyType).or(() -> OpenApiGeneratorCodeGenBase.getValuesBySpecConfigName(config, openApiFilePath, configName, propertyType));
    }

    private <K, V> Optional<Map<K, V>> getValues(SmallRyeConfig config, Path openApiFilePath, CodegenConfig.ConfigName configName, Class<K> kClass, Class<V> vClass) {
        return this.getConfigKeyValues(config, openApiFilePath, configName, kClass, vClass).or(() -> OpenApiGeneratorCodeGenBase.getValuesBySpecConfigName(config, openApiFilePath, configName, kClass, vClass));
    }

    private static <T> Optional<T> getValuesBySpecConfigName(Config config, Path openApiFilePath, CodegenConfig.ConfigName configName, Class<T> propertyType) {
        return config.getOptionalValue(CodegenConfig.getSpecConfigName(configName, openApiFilePath), propertyType).or(() -> config.getOptionalValue(CodegenConfig.getGlobalConfigName(configName), propertyType));
    }

    private static <K, V> Optional<Map<K, V>> getValuesBySpecConfigName(SmallRyeConfig config, Path openApiFilePath, CodegenConfig.ConfigName configName, Class<K> kClass, Class<V> vClass) {
        return config.getOptionalValues(CodegenConfig.getSpecConfigName(configName, openApiFilePath), kClass, vClass).or(() -> config.getOptionalValues(CodegenConfig.getGlobalConfigName(configName), kClass, vClass));
    }

    private static <T> Optional<T> getValuesByConfigKey(Config config, String configName, Class<T> propertyType, CodegenConfig.ConfigName codegenConfigName) {
        return config.getOptionalValue(configName, propertyType).or(() -> config.getOptionalValue(CodegenConfig.getGlobalConfigName(codegenConfigName), propertyType));
    }

    private static <K, V> Optional<Map<K, V>> getValuesByConfigKey(SmallRyeConfig config, CodegenConfig.ConfigName configName, Class<K> kClass, Class<V> vClass, String configKey) {
        return config.getOptionalValues(CodegenConfig.getSpecConfigNameByConfigKey(configKey, configName), kClass, vClass).or(() -> config.getOptionalValues(CodegenConfig.getGlobalConfigName(configName), kClass, vClass));
    }

    private static Optional<String> getConfigKeyValue(Config config, Path openApiFilePath) {
        String configKey = String.format("quarkus.openapi-generator.codegen.spec.%s.%s", CodegenConfig.getSanitizedFileName(openApiFilePath), CONFIG_KEY_PROPERTY);
        return config.getOptionalValue(configKey, String.class).filter(Predicate.not(String::isBlank));
    }

    private <T> Optional<T> getConfigKeyValues(Config config, Path openApiFilePath, CodegenConfig.ConfigName configName, Class<T> propertyType) {
        Optional<String> possibleConfigKey = OpenApiGeneratorCodeGenBase.getConfigKeyValue(config, openApiFilePath);
        if (possibleConfigKey.isPresent()) {
            return OpenApiGeneratorCodeGenBase.getValuesByConfigKey(config, CodegenConfig.getSpecConfigNameByConfigKey(possibleConfigKey.get(), configName), propertyType, configName);
        }
        return Optional.empty();
    }

    private <K, V> Optional<Map<K, V>> getConfigKeyValues(SmallRyeConfig config, Path openApiFilePath, CodegenConfig.ConfigName configName, Class<K> kClass, Class<V> vClass) {
        Optional<String> possibleConfigKey = OpenApiGeneratorCodeGenBase.getConfigKeyValue((Config)config, openApiFilePath);
        if (possibleConfigKey.isPresent()) {
            return OpenApiGeneratorCodeGenBase.getValuesByConfigKey(config, configName, kClass, vClass, possibleConfigKey.get());
        }
        return Optional.empty();
    }
}

