/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.providers;

import io.quarkiverse.loggingjson.Enabled;
import io.quarkiverse.loggingjson.JsonGenerator;
import io.quarkiverse.loggingjson.JsonProvider;
import io.quarkiverse.loggingjson.JsonWritingUtils;
import io.quarkiverse.loggingjson.config.Config;
import java.io.IOException;
import org.jboss.logmanager.ExtLogRecord;

public class LogLevelJsonProvider
implements JsonProvider,
Enabled {
    private final String fieldName;
    private final Config.FieldConfig config;

    public LogLevelJsonProvider(Config.FieldConfig config) {
        this(config, "level");
    }

    public LogLevelJsonProvider(Config.FieldConfig config, String defaultName) {
        this.config = config;
        this.fieldName = config.fieldName.orElse(defaultName);
    }

    @Override
    public void writeTo(JsonGenerator generator, ExtLogRecord event) throws IOException {
        JsonWritingUtils.writeStringField(generator, this.fieldName, event.getLevel().toString());
    }

    @Override
    public boolean isEnabled() {
        return this.config.enabled.orElse(true);
    }
}

