/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.config;

import io.quarkiverse.loggingjson.config.ConfigConsole;
import io.quarkiverse.loggingjson.config.ConfigFile;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.RUN_TIME, name="log.json")
public class Config {
    @ConfigItem(name="console")
    public ConfigConsole console;
    @ConfigItem(name="file")
    public ConfigFile file;
    @ConfigItem
    public FieldsConfig fields;
    @ConfigItem
    public boolean prettyPrint;
    @ConfigItem(defaultValue="\n")
    public String recordDelimiter;
    @ConfigItem
    public Map<String, AdditionalFieldConfig> additionalField;
    @ConfigItem(defaultValue="DEFAULT")
    public LogFormat logFormat;

    public static enum LogFormat {
        DEFAULT,
        ECS;

    }

    public static enum AdditionalFieldType {
        STRING,
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }

    @ConfigGroup
    public static class AdditionalFieldConfig {
        @ConfigItem
        public String value;
        @ConfigItem(defaultValue="STRING")
        public AdditionalFieldType type;
    }

    @ConfigGroup
    public static class ArgumentsConfig {
        @ConfigItem
        public Optional<String> fieldName = Optional.empty();
        @ConfigItem(defaultValue="true")
        public boolean includeStructuredArguments;
        @ConfigItem(defaultValue="false")
        public boolean includeNonStructuredArguments;
        @ConfigItem(defaultValue="arg")
        public String nonStructuredArgumentsFieldPrefix;
    }

    @ConfigGroup
    public static class TimestampField {
        @ConfigItem
        public Optional<String> fieldName;
        @ConfigItem(defaultValue="default")
        public String dateFormat;
        @ConfigItem(defaultValue="default")
        public String zoneId;
        @ConfigItem
        public Optional<Boolean> enabled;
    }

    @ConfigGroup
    public static class MDCConfig {
        @ConfigItem
        public Optional<String> fieldName;
        @ConfigItem
        public Optional<Boolean> enabled;
        @ConfigItem(defaultValue="false")
        public boolean flatFields;
    }

    @ConfigGroup
    public static class FieldConfig {
        @ConfigItem
        public Optional<String> fieldName;
        @ConfigItem
        public Optional<Boolean> enabled;
    }

    @ConfigGroup
    public static class FieldsConfig {
        @ConfigItem
        public ArgumentsConfig arguments;
        @ConfigItem
        public TimestampField timestamp;
        @ConfigItem
        public FieldConfig hostname;
        @ConfigItem
        public FieldConfig sequence;
        @ConfigItem
        public FieldConfig loggerClassName;
        @ConfigItem
        public FieldConfig loggerName;
        @ConfigItem
        public FieldConfig level;
        @ConfigItem
        public FieldConfig message;
        @ConfigItem
        public FieldConfig threadName;
        @ConfigItem
        public FieldConfig threadId;
        @ConfigItem
        public MDCConfig mdc;
        @ConfigItem
        public FieldConfig ndc;
        @ConfigItem
        public FieldConfig processName;
        @ConfigItem
        public FieldConfig processId;
        @ConfigItem
        public FieldConfig stackTrace;
        @ConfigItem
        public FieldConfig errorType;
        @ConfigItem
        public FieldConfig errorMessage;
    }
}

