/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.deployment.apache;

import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientTransportBuilderBuildItem;
import io.quarkiverse.amazon.common.runtime.AmazonClientApacheTransportRecorder;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.runtime.RuntimeValue;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.DotName;

public class ApacheTransportBuilderProcessor {
    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupApacheSyncTransport(List<AmazonClientExtensionBuildItem> extensions, List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, AmazonClientApacheTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        extensions.forEach(extension -> this.createApacheSyncTransportBuilder(extension.getConfigName(), amazonClients, transportRecorder, extension.getBuildSyncConfig(), (RuntimeValue<SyncHttpClientConfig>)extension.getSyncConfig(), syncTransports));
    }

    void createApacheSyncTransportBuilder(String configName, List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, AmazonClientApacheTransportRecorder recorder, SyncHttpClientBuildTimeConfig buildSyncConfig, RuntimeValue<SyncHttpClientConfig> syncConfig, BuildProducer<AmazonClientSyncTransportBuildItem> clientSyncTransports) {
        Optional<RequireAmazonClientTransportBuilderBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(configName)).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getSyncClassName().isPresent()) {
                return;
            }
            if (buildSyncConfig.type() != SyncHttpClientBuildTimeConfig.SyncClientType.APACHE) {
                return;
            }
            clientSyncTransports.produce((BuildItem)new AmazonClientSyncTransportBuildItem(client.getAwsClientName(), (DotName)client.getSyncClassName().get(), recorder.configureSync(configName, syncConfig)));
        });
    }
}

