/*
 * Decompiled with CFR 0.152.
 */
package io.qdrant.client;

import io.qdrant.client.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionsCompatibilityChecker {
    private static final Logger logger = LoggerFactory.getLogger(VersionsCompatibilityChecker.class);

    private static Version parseVersion(String version) throws IllegalArgumentException {
        if (version.isEmpty()) {
            throw new IllegalArgumentException("Version is None");
        }
        try {
            String[] parts = version.split("\\.");
            int major = parts.length > 0 ? Integer.parseInt(parts[0]) : 0;
            int minor = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            return new Version(major, minor);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse version, expected format: x.y[.z], found: " + version, e);
        }
    }

    public static boolean isCompatible(String clientVersion, String serverVersion) {
        try {
            Version client = VersionsCompatibilityChecker.parseVersion(clientVersion);
            Version server = VersionsCompatibilityChecker.parseVersion(serverVersion);
            if (client.getMajor() != server.getMajor()) {
                return false;
            }
            return Math.abs(client.getMinor() - server.getMinor()) <= 1;
        }
        catch (IllegalArgumentException e) {
            logger.warn("Version comparison failed: {}", (Object)e.getMessage());
            return false;
        }
    }
}

