/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.springweb;

import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentProcessor;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentProcessor;
import io.qameta.allure.attachment.FreemarkerAttachmentRenderer;
import io.qameta.allure.attachment.http.HttpRequestAttachment;
import io.qameta.allure.attachment.http.HttpResponseAttachment;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.util.StreamUtils;

public class AllureRestTemplate
implements ClientHttpRequestInterceptor {
    private String requestTemplatePath = "http-request.ftl";
    private String responseTemplatePath = "http-response.ftl";

    public String getRequestTemplatePath() {
        return this.requestTemplatePath;
    }

    public String getResponseTemplatePath() {
        return this.responseTemplatePath;
    }

    public AllureRestTemplate setRequestTemplate(String templatePath) {
        this.requestTemplatePath = templatePath;
        return this;
    }

    public AllureRestTemplate setResponseTemplate(String templatePath) {
        this.responseTemplatePath = templatePath;
        return this;
    }

    protected AttachmentRenderer<AttachmentData> getRequestRenderer() {
        return new FreemarkerAttachmentRenderer(this.getRequestTemplatePath());
    }

    protected AttachmentRenderer<AttachmentData> getResponseRenderer() {
        return new FreemarkerAttachmentRenderer(this.getResponseTemplatePath());
    }

    protected AttachmentProcessor<AttachmentData> getAttachmentProcessor() {
        return new DefaultAttachmentProcessor();
    }

    public ClientHttpResponse intercept(@NonNull HttpRequest request, byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
        AttachmentProcessor<AttachmentData> processor = this.getAttachmentProcessor();
        HttpRequestAttachment.Builder requestAttachmentBuilder = HttpRequestAttachment.Builder.create((String)"Request", (String)request.getURI().toString()).setMethod(request.getMethodValue()).setHeaders(AllureRestTemplate.toMapConverter((Map<String, List<String>>)request.getHeaders()));
        if (body.length != 0) {
            requestAttachmentBuilder.setBody(new String(body, StandardCharsets.UTF_8));
        }
        HttpRequestAttachment requestAttachment = requestAttachmentBuilder.build();
        processor.addAttachment((AttachmentData)requestAttachment, this.getRequestRenderer());
        ClientHttpResponse clientHttpResponse = execution.execute(request, body);
        HttpResponseAttachment responseAttachment = HttpResponseAttachment.Builder.create((String)"Response").setResponseCode(clientHttpResponse.getRawStatusCode()).setHeaders(AllureRestTemplate.toMapConverter((Map<String, List<String>>)clientHttpResponse.getHeaders())).setBody(StreamUtils.copyToString((InputStream)clientHttpResponse.getBody(), (Charset)StandardCharsets.UTF_8)).build();
        processor.addAttachment((AttachmentData)responseAttachment, this.getResponseRenderer());
        return clientHttpResponse;
    }

    protected static Map<String, String> toMapConverter(Map<String, List<String>> items) {
        HashMap<String, String> result = new HashMap<String, String>();
        items.forEach((key, value) -> result.put((String)key, String.join((CharSequence)"; ", value)));
        return result;
    }
}

