/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.servletapi;

import io.qameta.allure.attachment.http.HttpRequestAttachment;
import io.qameta.allure.attachment.http.HttpResponseAttachment;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpServletAttachmentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServletAttachmentBuilder.class);

    private HttpServletAttachmentBuilder() {
        throw new IllegalStateException();
    }

    public static HttpRequestAttachment buildRequest(HttpServletRequest request) {
        HttpRequestAttachment.Builder requestBuilder = HttpRequestAttachment.Builder.create((String)"Request", (String)request.getRequestURI());
        Collections.list(request.getHeaderNames()).forEach(name -> {
            String value = request.getHeader(name);
            requestBuilder.setHeader(name, value);
        });
        Stream.of(request.getCookies()).forEach(cookie -> requestBuilder.setCookie(cookie.getName(), cookie.getValue()));
        requestBuilder.setBody(HttpServletAttachmentBuilder.getBody(request));
        return requestBuilder.build();
    }

    public static HttpResponseAttachment buildResponse(HttpServletResponse response) {
        HttpResponseAttachment.Builder responseBuilder = HttpResponseAttachment.Builder.create((String)"Response");
        response.getHeaderNames().forEach(name -> response.getHeaders(name).forEach(value -> responseBuilder.setHeader(name, value)));
        return responseBuilder.build();
    }

    public static String getBody(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            HttpServletAttachmentBuilder.readBody(sb, reader);
        }
        catch (IOException e) {
            LOGGER.warn("Could not read request body", (Throwable)e);
        }
        return sb.toString();
    }

    public static void readBody(StringBuilder sb, BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
    }
}

