/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.jsonunit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentProcessor;
import io.qameta.allure.attachment.FreemarkerAttachmentRenderer;
import io.qameta.allure.jsonunit.AllureConfigurableJsonMatcher;
import io.qameta.allure.jsonunit.DiffAttachment;
import io.qameta.allure.jsonunit.JsonPatchListener;
import java.math.BigDecimal;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.Options;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public final class JsonPatchMatcher<T>
implements AllureConfigurableJsonMatcher<T> {
    private static final String EMPTY_PATH = "";
    private static final String FULL_JSON = "fullJson";
    private Configuration configuration = Configuration.empty();
    private final Object expected;
    private String differences;

    private JsonPatchMatcher(Object expected) {
        this.expected = expected;
    }

    public static <T> AllureConfigurableJsonMatcher<T> jsonEquals(Object expected) {
        return new JsonPatchMatcher<T>(expected);
    }

    @Override
    public AllureConfigurableJsonMatcher<T> withTolerance(BigDecimal tolerance) {
        this.configuration = this.configuration.withTolerance(tolerance);
        return this;
    }

    @Override
    public AllureConfigurableJsonMatcher<T> withTolerance(double tolerance) {
        this.configuration = this.configuration.withTolerance(tolerance);
        return this;
    }

    @Override
    public AllureConfigurableJsonMatcher<T> when(Option first, Option ... next) {
        this.configuration = this.configuration.when(first, next);
        return this;
    }

    @Override
    public AllureConfigurableJsonMatcher<T> withOptions(Options options) {
        this.configuration = this.configuration.withOptions(options);
        return this;
    }

    @Override
    public AllureConfigurableJsonMatcher<T> withMatcher(String matcherName, Matcher matcher) {
        this.configuration = this.configuration.withMatcher(matcherName, matcher);
        return this;
    }

    @Override
    public AllureConfigurableJsonMatcher<T> whenIgnoringPaths(String ... paths) {
        this.configuration = this.configuration.whenIgnoringPaths(paths);
        return this;
    }

    public boolean matches(Object actual) {
        JsonPatchListener listener = new JsonPatchListener();
        Diff diff = Diff.create((Object)this.expected, (Object)actual, (String)FULL_JSON, (String)EMPTY_PATH, (Configuration)this.configuration.withDifferenceListener((DifferenceListener)listener));
        if (!diff.similar()) {
            this.differences = diff.differences();
            this.render(listener);
        }
        return diff.similar();
    }

    public void describeTo(Description description) {
        description.appendText("has no difference");
    }

    public void describeMismatch(Object item, Description description) {
        description.appendText(this.differences);
    }

    public void _dont_implement_Matcher___instead_extend_BaseMatcher_() {
    }

    private void render(JsonPatchListener listener) {
        ObjectMapper mapper = new ObjectMapper();
        String patch = listener.getJsonPatch();
        try {
            String actual = mapper.writeValueAsString(listener.getContext().getActualSource());
            String expected = mapper.writeValueAsString(listener.getContext().getExpectedSource());
            DiffAttachment attachment = new DiffAttachment(actual, expected, patch);
            new DefaultAttachmentProcessor().addAttachment((AttachmentData)attachment, (AttachmentRenderer)new FreemarkerAttachmentRenderer("diff.ftl"));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not process actual/expected json", e);
        }
    }
}

