/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.jsonunit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.jsonunit.DiffModel;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.javacrumbs.jsonunit.core.listener.Difference;
import net.javacrumbs.jsonunit.core.listener.DifferenceContext;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;

public class JsonPatchListener
implements DifferenceListener {
    private static final String UNKNOWN_TYPE_ERROR = "Difference has unknown type";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final List<Difference> differences = new ArrayList<Difference>();
    private DifferenceContext context;

    public void diff(Difference difference, DifferenceContext differenceContext) {
        this.context = differenceContext;
        this.differences.add(difference);
    }

    public List<Difference> getDifferences() {
        return this.differences;
    }

    public DifferenceContext getContext() {
        return this.context;
    }

    private String getPath(Difference difference) {
        switch (difference.getType()) {
            case DIFFERENT: {
                return difference.getActualPath();
            }
            case MISSING: {
                return difference.getExpectedPath();
            }
            case EXTRA: {
                return difference.getActualPath();
            }
        }
        throw new IllegalArgumentException(UNKNOWN_TYPE_ERROR);
    }

    private List<Object> getPatch(Difference difference) {
        ArrayList<Object> result = new ArrayList<Object>();
        switch (difference.getType()) {
            case DIFFERENT: {
                result.add(difference.getExpected());
                result.add(difference.getActual());
                return result;
            }
            case MISSING: {
                result.add(difference.getExpected());
                result.add(0);
                result.add(0);
                return result;
            }
            case EXTRA: {
                result.add(difference.getActual());
                return result;
            }
        }
        throw new IllegalArgumentException(UNKNOWN_TYPE_ERROR);
    }

    public DiffModel getDiffModel() {
        return new DiffModel(JsonPatchListener.writeAsString(this.context.getActualSource(), "actual"), JsonPatchListener.writeAsString(this.context.getExpectedSource(), "expected"), this.getJsonPatch());
    }

    public String getJsonPatch() {
        Difference difference2;
        String field;
        HashMap jsonDiffPatch = new HashMap();
        if (this.getDifferences().size() == 1 && (field = this.getPath(difference2 = this.getDifferences().get(0))).isEmpty()) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writeValueAsString(this.getPatch(difference2));
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("Could not process patch json", e);
            }
        }
        this.getDifferences().forEach(difference -> {
            String field = this.getPath((Difference)difference);
            Map currentMap = jsonDiffPatch;
            String fieldWithDots = field.replace('[', '.');
            int len = fieldWithDots.length();
            int left = 0;
            int right = 0;
            while (left < len) {
                right = fieldWithDots.indexOf(46, left);
                if (right == -1) {
                    right = len;
                }
                String fieldName = fieldWithDots.substring(left, right);
                fieldName = fieldName.replaceAll("]", "");
                if (right != len) {
                    if (!fieldName.isEmpty()) {
                        if (!currentMap.containsKey(fieldName)) {
                            currentMap.put(fieldName, new HashMap());
                        }
                        currentMap = (Map)currentMap.get(fieldName);
                    }
                    if (field.charAt(right) == '[' && !currentMap.containsKey(fieldName)) {
                        currentMap.put("_t", "a");
                    }
                } else {
                    List<Object> actualExpectedValue = this.getPatch((Difference)difference);
                    currentMap.put(fieldName, actualExpectedValue);
                }
                left = right + 1;
            }
        });
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(jsonDiffPatch);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not process patch json", e);
        }
    }

    private static String writeAsString(Object object, String failDescription) {
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException(String.format("Could not process %s json", failDescription), (IOException)((Object)e));
        }
    }
}

