/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.jsonunit;

import java.math.BigDecimal;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.Options;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import org.hamcrest.Matcher;

public abstract class AbstractJsonPatchMatcher<T> {
    private static final String EMPTY_PATH = "";
    private static final String FULL_JSON = "fullJson";
    private Configuration configuration = Configuration.empty();
    private String differences;

    public T withTolerance(BigDecimal tolerance) {
        this.configuration = this.configuration.withTolerance(tolerance);
        return (T)this;
    }

    public T withTolerance(double tolerance) {
        this.configuration = this.configuration.withTolerance(tolerance);
        return (T)this;
    }

    public T when(Option first, Option ... next) {
        this.configuration = this.configuration.when(first, next);
        return (T)this;
    }

    public T withOptions(Options options) {
        this.configuration = this.configuration.withOptions(options);
        return (T)this;
    }

    public T withMatcher(String matcherName, Matcher matcher) {
        this.configuration = this.configuration.withMatcher(matcherName, matcher);
        return (T)this;
    }

    public T whenIgnoringPaths(String ... paths) {
        this.configuration = this.configuration.whenIgnoringPaths(paths);
        return (T)this;
    }

    public T withDifferenceListener(DifferenceListener differenceListener) {
        this.configuration = this.configuration.withDifferenceListener(differenceListener);
        return (T)this;
    }

    public boolean matches(Object expected, Object actual) {
        Diff diff = Diff.create((Object)expected, (Object)actual, (String)FULL_JSON, (String)EMPTY_PATH, (Configuration)this.configuration);
        boolean similar = diff.similar();
        if (!similar) {
            this.differences = diff.differences();
            this.render(this.configuration.getDifferenceListener());
        }
        return similar;
    }

    protected abstract void render(DifferenceListener var1);

    public String getDifferences() {
        return this.differences;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

