/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.aspects;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Step;
import io.qameta.allure.model.ExecutableItem;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.ResultsUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.joor.Reflect;

@Aspect
public class StepsAspects {
    private static AllureLifecycle lifecycle;

    @Pointcut(value="@annotation(io.qameta.allure.Step)")
    public void withStepAnnotation() {
    }

    @Pointcut(value="execution(* *(..))")
    public void anyMethod() {
    }

    @Before(value="anyMethod() && withStepAnnotation()")
    public void stepStart(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String uuid = UUID.randomUUID().toString();
        StepResult result = new StepResult().withName(StepsAspects.getName(methodSignature, joinPoint.getArgs())).withParameters(StepsAspects.getParameters(methodSignature, joinPoint.getArgs()));
        ResultsUtils.processDescription(this.getClass().getClassLoader(), methodSignature.getMethod(), (ExecutableItem)result);
        StepsAspects.getLifecycle().startStep(uuid, result);
    }

    @AfterThrowing(pointcut="anyMethod() && withStepAnnotation()", throwing="e")
    public void stepFailed(Throwable e) {
        StepsAspects.getLifecycle().updateStep(result -> result.withStatus(ResultsUtils.getStatus(e).orElse(Status.BROKEN)).withStatusDetails((StatusDetails)ResultsUtils.getStatusDetails(e).orElse(null)));
        StepsAspects.getLifecycle().stopStep();
    }

    @AfterReturning(value="anyMethod() && withStepAnnotation()")
    public void stepStop() {
        StepsAspects.getLifecycle().updateStep(step -> step.withStatus(Status.PASSED));
        StepsAspects.getLifecycle().stopStep();
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle = allure;
    }

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = Allure.getLifecycle();
        }
        return lifecycle;
    }

    private static Parameter[] getParameters(MethodSignature signature, Object ... args) {
        return (Parameter[])IntStream.range(0, args.length).mapToObj(index -> {
            String name = signature.getParameterNames()[index];
            String value = Objects.toString(args[index]);
            return new Parameter().withName(name).withValue(value);
        }).toArray(Parameter[]::new);
    }

    private static String getMatchingPropertyValue(String input, Function<String, Object> parameterExtractor) {
        Matcher matcher = Pattern.compile("\\{([^}]*)}").matcher(input);
        String output = input;
        while (matcher.find()) {
            String[] matches = matcher.group(1).split("\\.");
            Object parameter = parameterExtractor.apply(matches[0]);
            output = parameter != null ? output.replace(matcher.group(0), StepsAspects.getParameterPropertyValue(parameter, matches)) : output;
        }
        return output;
    }

    private static Object getMatchingParameterValue(MethodSignature signature, String parameterName, Object ... args) {
        return IntStream.range(0, args.length).filter(i -> parameterName.equals(signature.getParameterNames()[i])).mapToObj(i -> args[i]).findFirst().orElse(null);
    }

    private static String getParameterPropertyValue(Object rootObject, String ... fieldNames) {
        Object currentObject = rootObject;
        for (int i = 1; i < fieldNames.length; ++i) {
            int currentIndex = i;
            if (currentObject == null) break;
            currentObject = currentObject instanceof Collection ? Stream.of((Collection)currentObject).map(ob -> StepsAspects.extractProperty(ob, fieldNames[currentIndex])).collect(Collectors.toList()) : (currentObject instanceof Object[] ? Stream.of((Object[])currentObject).map(ob -> StepsAspects.extractProperty(ob, fieldNames[currentIndex])).toArray() : StepsAspects.extractProperty(currentObject, fieldNames[currentIndex]));
        }
        return Optional.ofNullable(currentObject).filter(ob -> ob instanceof Object[]).map(ob -> Objects.toString(Arrays.asList((Object[])ob))).orElse(Objects.toString(currentObject));
    }

    private static Object extractProperty(Object rootObject, String fileName) {
        try {
            return Reflect.on((Object)rootObject).get(fileName);
        }
        catch (Exception ignored) {
            return rootObject;
        }
    }

    private static String getName(MethodSignature signature, Object ... args) {
        return Optional.ofNullable(signature.getMethod().getAnnotation(Step.class)).map(Step::value).filter(value -> !value.isEmpty()).map(value -> StepsAspects.getMatchingPropertyValue(value, arg -> StepsAspects.getMatchingParameterValue(signature, arg, args))).orElseGet(() -> ((MethodSignature)signature).getName());
    }
}

