/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.AllureResultsWriter;
import io.qameta.allure.FileSystemResultsWriter;
import io.qameta.allure.model.Attachment;
import io.qameta.allure.model.ExecutableItem;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.model.WithAttachments;
import io.qameta.allure.model.WithSteps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureLifecycle.class);
    private final Map<String, Object> storage = new ConcurrentHashMap<String, Object>();
    private final ThreadLocal<LinkedList<String>> currentStepContext = InheritableThreadLocal.withInitial(LinkedList::new);
    private final AllureResultsWriter writer;

    public AllureLifecycle(AllureResultsWriter writer) {
        this.writer = writer;
    }

    public AllureLifecycle() {
        this((AllureResultsWriter)AllureLifecycle.getDefaultWriter());
    }

    private static FileSystemResultsWriter getDefaultWriter() {
        String path = System.getProperty("allure.results.directory", "allure-results");
        return new FileSystemResultsWriter(Paths.get(path, new String[0]));
    }

    public void startTestContainer(String parentUuid, TestResultContainer container) {
        this.get(parentUuid, TestResultContainer.class).getChildren().add(container.getUuid());
        this.startTestContainer(container);
    }

    public void startTestContainer(TestResultContainer container) {
        LOGGER.debug("Start test result container {}", (Object)container.getUuid());
        this.put(container.getUuid(), container).withStart(Long.valueOf(System.currentTimeMillis()));
    }

    public void updateTestContainer(String uuid, Consumer<TestResultContainer> update) {
        LOGGER.debug("Update test result container {}", (Object)uuid);
        update.accept(this.get(uuid, TestResultContainer.class));
    }

    public void stopTestContainer(String uuid) {
        LOGGER.debug("Stop test result container {}", (Object)uuid);
        this.get(uuid, TestResultContainer.class).withStop(Long.valueOf(System.currentTimeMillis()));
    }

    public void writeTestContainer(String uuid) {
        LOGGER.debug("Stop test group {}", (Object)uuid);
        this.writer.write(this.remove(uuid, TestResultContainer.class));
    }

    public void startBeforeFixture(String parentUuid, String uuid, FixtureResult result) {
        LOGGER.debug("Start test before {} with parent {}", (Object)uuid, (Object)parentUuid);
        this.startFixture(parentUuid, uuid, result, TestResultContainer::getBefores);
    }

    public void startAfterFixture(String parentUuid, String uuid, FixtureResult result) {
        LOGGER.debug("Start test after {} with parent {}", (Object)uuid, (Object)parentUuid);
        this.startFixture(parentUuid, uuid, result, TestResultContainer::getAfters);
    }

    private void startFixture(String parentUuid, String uuid, FixtureResult result, Function<TestResultContainer, List<FixtureResult>> fixturesGetter) {
        this.put(uuid, result).withStage(Stage.RUNNING).withStart(Long.valueOf(System.currentTimeMillis()));
        TestResultContainer container = this.get(parentUuid, TestResultContainer.class);
        fixturesGetter.apply(container).add(result);
        this.currentStepContext.remove();
        this.currentStepContext.get().push(uuid);
    }

    public void updateFixture(Consumer<FixtureResult> update) {
        String uuid = this.currentStepContext.get().getLast();
        this.updateFixture(uuid, update);
    }

    public void updateFixture(String uuid, Consumer<FixtureResult> update) {
        LOGGER.debug("Update test group {}", (Object)uuid);
        update.accept(this.get(uuid, FixtureResult.class));
    }

    public void stopFixture(String uuid) {
        LOGGER.debug("Stop test before {}", (Object)uuid);
        this.currentStepContext.remove();
        this.remove(uuid, FixtureResult.class).withStage(Stage.FINISHED).withStop(Long.valueOf(System.currentTimeMillis()));
    }

    public void scheduleTestCase(String parentUuid, TestResult result) {
        LOGGER.debug("Add test case {} to {}", (Object)result.getUuid(), (Object)parentUuid);
        this.get(parentUuid, TestResultContainer.class).getChildren().add(result.getUuid());
        this.scheduleTestCase(result);
    }

    public void scheduleTestCase(TestResult result) {
        LOGGER.debug("Schedule test case {}", (Object)result.getUuid());
        this.put(result.getUuid(), result).withStage(Stage.SCHEDULED);
    }

    public void startTestCase(String uuid) {
        LOGGER.debug("Start test case {}", (Object)uuid);
        this.get(uuid, TestResult.class).withStage(Stage.RUNNING).withStart(Long.valueOf(System.currentTimeMillis()));
        this.currentStepContext.remove();
        this.currentStepContext.get().push(uuid);
    }

    public void updateTestCase(Consumer<TestResult> update) {
        String uuid = this.currentStepContext.get().getLast();
        this.updateTestCase(uuid, update);
    }

    public void updateTestCase(String uuid, Consumer<TestResult> update) {
        LOGGER.debug("Update test case {}", (Object)uuid);
        update.accept(this.get(uuid, TestResult.class));
    }

    public void stopTestCase(String uuid) {
        LOGGER.debug("Stop test case {}", (Object)uuid);
        this.currentStepContext.remove();
        this.get(uuid, TestResult.class).withStage(Stage.FINISHED).withStop(Long.valueOf(System.currentTimeMillis()));
    }

    public void updateExecutable(Consumer<ExecutableItem> update) {
        String uuid = this.currentStepContext.get().getLast();
        this.updateExecutable(uuid, update);
    }

    public void updateExecutable(String uuid, Consumer<ExecutableItem> update) {
        LOGGER.debug("Update executable {}", (Object)uuid);
        update.accept(this.get(uuid, ExecutableItem.class));
    }

    public void writeTestCase(String uuid) {
        LOGGER.debug("Close test case {}", (Object)uuid);
        this.writer.write(this.remove(uuid, TestResult.class));
    }

    public void addAttachment(String name, String type, String fileExtension, byte[] body) {
        this.addAttachment(name, type, fileExtension, new ByteArrayInputStream(body));
    }

    public void addAttachment(String name, String type, String fileExtension, InputStream stream) {
        this.writeAttachment(this.prepareAttachment(name, type, fileExtension), stream);
    }

    public String prepareAttachment(String name, String type, String fileExtension) {
        String uuid = this.currentStepContext.get().getFirst();
        LOGGER.debug("Adding attachment to item with uuid {}", (Object)uuid);
        String extension = Optional.ofNullable(fileExtension).filter(ext -> !ext.isEmpty()).map(ext -> ext.charAt(0) == '.' ? ext : "." + ext).orElse("");
        String source = UUID.randomUUID().toString() + "-attachment" + extension;
        Attachment attachment = new Attachment().withName(this.isEmpty(name) ? null : name).withType(this.isEmpty(type) ? null : type).withSource(source);
        this.get(uuid, WithAttachments.class).getAttachments().add(attachment);
        return attachment.getSource();
    }

    public void writeAttachment(String attachmentSource, InputStream stream) {
        this.writer.write(attachmentSource, stream);
    }

    public void addStep(StepResult result) {
        this.get(this.currentStepContext.get().getFirst(), WithSteps.class).getSteps().add(result);
    }

    public void startStep(String uuid, StepResult result) {
        LinkedList<String> uuids = this.currentStepContext.get();
        this.startStep(uuids.isEmpty() ? null : uuids.getFirst(), uuid, result);
    }

    public void startStep(String parentUuid, String uuid, StepResult result) {
        LOGGER.debug("Start step {} with parent {}", (Object)uuid, (Object)parentUuid);
        this.put(uuid, result).withStage(Stage.RUNNING).withStart(Long.valueOf(System.currentTimeMillis()));
        this.currentStepContext.get().push(uuid);
        if (Objects.nonNull(parentUuid)) {
            this.get(parentUuid, WithSteps.class).getSteps().add(result);
        }
    }

    public void updateStep(Consumer<StepResult> update) {
        this.updateStep(this.currentStepContext.get().getFirst(), update);
    }

    public void updateStep(String uuid, Consumer<StepResult> update) {
        LOGGER.debug("Update step {}", (Object)uuid);
        update.accept(this.get(uuid, StepResult.class));
    }

    public void stopStep() {
        this.stopStep(this.currentStepContext.get().getFirst());
    }

    public void stopStep(String uuid) {
        LOGGER.debug("Stop step {}", (Object)uuid);
        this.remove(uuid, StepResult.class).withStage(Stage.FINISHED).withStop(Long.valueOf(System.currentTimeMillis()));
        this.currentStepContext.get().pop();
    }

    private <T> T put(String uuid, T item) {
        Objects.requireNonNull(uuid, "Can't put item to storage: uuid can't be null");
        this.storage.put(uuid, item);
        return item;
    }

    private <T> T get(String uuid, Class<T> clazz) {
        Objects.requireNonNull(uuid, "Can't get item from storage: uuid can't be null");
        Object obj = Objects.requireNonNull(this.storage.get(uuid), String.format("Could not get %s by uuid %s", clazz, uuid));
        return this.cast(obj, clazz);
    }

    private <T> T remove(String uuid, Class<T> clazz) {
        Objects.requireNonNull(uuid, "Can't remove item from storage: uuid can't be null");
        Object obj = Objects.requireNonNull(this.storage.remove(uuid), String.format("Could not remove %s by uuid %s", clazz, uuid));
        return this.cast(obj, clazz);
    }

    private <T> T cast(Object obj, Class<T> clazz) {
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        throw new IllegalStateException("Can not cast " + obj + " to " + clazz);
    }

    private boolean isEmpty(String s) {
        return Objects.isNull(s) || s.isEmpty();
    }
}

