/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.listener;

import io.qameta.allure.listener.ContainerLifecycleListener;
import io.qameta.allure.listener.FixtureLifecycleListener;
import io.qameta.allure.listener.StepLifecycleListener;
import io.qameta.allure.listener.TestLifecycleListener;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import java.util.List;

public class LifecycleNotifier
implements ContainerLifecycleListener,
TestLifecycleListener,
FixtureLifecycleListener,
StepLifecycleListener {
    private final List<ContainerLifecycleListener> containerListeners;
    private final List<TestLifecycleListener> testListeners;
    private final List<FixtureLifecycleListener> fixtureListeners;
    private final List<StepLifecycleListener> stepListeners;

    public LifecycleNotifier(List<ContainerLifecycleListener> containerListeners, List<TestLifecycleListener> testListeners, List<FixtureLifecycleListener> fixtureListeners, List<StepLifecycleListener> stepListeners) {
        this.containerListeners = containerListeners;
        this.testListeners = testListeners;
        this.fixtureListeners = fixtureListeners;
        this.stepListeners = stepListeners;
    }

    @Override
    public void beforeTestSchedule(TestResult result) {
        this.testListeners.forEach(listener -> listener.beforeTestSchedule(result));
    }

    @Override
    public void afterTestSchedule(TestResult result) {
        this.testListeners.forEach(listener -> listener.afterTestSchedule(result));
    }

    @Override
    public void beforeTestUpdate(TestResult result) {
        this.testListeners.forEach(listener -> listener.beforeTestUpdate(result));
    }

    @Override
    public void afterTestUpdate(TestResult result) {
        this.testListeners.forEach(listener -> listener.afterTestUpdate(result));
    }

    @Override
    public void beforeTestStart(TestResult result) {
        this.testListeners.forEach(listener -> listener.beforeTestStart(result));
    }

    @Override
    public void afterTestStart(TestResult result) {
        this.testListeners.forEach(listener -> listener.afterTestStart(result));
    }

    @Override
    public void beforeTestStop(TestResult result) {
        this.testListeners.forEach(listener -> listener.beforeTestStop(result));
    }

    @Override
    public void afterTestStop(TestResult result) {
        this.testListeners.forEach(listener -> listener.afterTestStop(result));
    }

    @Override
    public void beforeTestWrite(TestResult result) {
        this.testListeners.forEach(listener -> listener.beforeTestWrite(result));
    }

    @Override
    public void afterTestWrite(TestResult result) {
        this.testListeners.forEach(listener -> listener.afterTestWrite(result));
    }

    @Override
    public void beforeContainerStart(TestResultContainer container) {
        this.containerListeners.forEach(listener -> listener.beforeContainerStart(container));
    }

    @Override
    public void afterContainerStart(TestResultContainer container) {
        this.containerListeners.forEach(listener -> listener.afterContainerStart(container));
    }

    @Override
    public void beforeContainerUpdate(TestResultContainer container) {
        this.containerListeners.forEach(listener -> listener.beforeContainerUpdate(container));
    }

    @Override
    public void afterContainerUpdate(TestResultContainer container) {
        this.containerListeners.forEach(listener -> listener.afterContainerUpdate(container));
    }

    @Override
    public void beforeContainerStop(TestResultContainer container) {
        this.containerListeners.forEach(listener -> listener.beforeContainerStop(container));
    }

    @Override
    public void afterContainerStop(TestResultContainer container) {
        this.containerListeners.forEach(listener -> listener.afterContainerStop(container));
    }

    @Override
    public void beforeContainerWrite(TestResultContainer container) {
        this.containerListeners.forEach(listener -> listener.beforeContainerWrite(container));
    }

    @Override
    public void afterContainerWrite(TestResultContainer container) {
        this.containerListeners.forEach(listener -> listener.afterContainerWrite(container));
    }

    @Override
    public void beforeFixtureStart(FixtureResult result) {
        this.fixtureListeners.forEach(listener -> listener.beforeFixtureStart(result));
    }

    @Override
    public void afterFixtureStart(FixtureResult result) {
        this.fixtureListeners.forEach(listener -> listener.afterFixtureStart(result));
    }

    @Override
    public void beforeFixtureUpdate(FixtureResult result) {
        this.fixtureListeners.forEach(listener -> listener.beforeFixtureUpdate(result));
    }

    @Override
    public void afterFixtureUpdate(FixtureResult result) {
        this.fixtureListeners.forEach(listener -> listener.afterFixtureUpdate(result));
    }

    @Override
    public void beforeFixtureStop(FixtureResult result) {
        this.fixtureListeners.forEach(listener -> listener.beforeFixtureStop(result));
    }

    @Override
    public void afterFixtureStop(FixtureResult result) {
        this.fixtureListeners.forEach(listener -> listener.afterFixtureStop(result));
    }

    @Override
    public void beforeStepStart(StepResult result) {
        this.stepListeners.forEach(listener -> listener.beforeStepStart(result));
    }

    @Override
    public void afterStepStart(StepResult result) {
        this.stepListeners.forEach(listener -> listener.afterStepStart(result));
    }

    @Override
    public void beforeStepUpdate(StepResult result) {
        this.stepListeners.forEach(listener -> listener.beforeStepUpdate(result));
    }

    @Override
    public void afterStepUpdate(StepResult result) {
        this.stepListeners.forEach(listener -> listener.afterStepUpdate(result));
    }

    @Override
    public void beforeStepStop(StepResult result) {
        this.stepListeners.forEach(listener -> listener.beforeStepStop(result));
    }

    @Override
    public void afterStepStop(StepResult result) {
        this.stepListeners.forEach(listener -> listener.afterStepStop(result));
    }
}

