/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.test;

import io.qameta.allure.model.Label;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.TestResult;
import java.util.Objects;
import java.util.function.Predicate;

public final class AllurePredicates {
    private AllurePredicates() {
        throw new IllegalStateException("Do not instance");
    }

    public static Predicate<TestResult> hasStatus(Status status) {
        return testResult -> status.equals((Object)testResult.getStatus());
    }

    public static Predicate<TestResult> hasLabel(String name, String value) {
        Predicate<Label> labelPredicate = label -> Objects.equals(label.getName(), name) && Objects.equals(label.getValue(), value);
        return testResult -> testResult.getLabels().stream().anyMatch(labelPredicate);
    }
}

