/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.test;

import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;

public interface AllureResults {
    public List<TestResult> getTestResults();

    public List<TestResultContainer> getTestResultContainers();

    public Map<String, byte[]> getAttachments();

    default public TestResult getTestResultByName(String name) {
        return this.getTestResults().stream().filter(tr -> Objects.equals(name, tr.getName())).findFirst().orElseThrow(() -> new NoSuchElementException("test result with name " + name + " is not found"));
    }

    default public List<TestResultContainer> getTestResultContainersForTestResult(TestResult testResult) {
        return this.getTestResultContainers().stream().filter(c -> Objects.nonNull(c.getChildren())).filter(c -> c.getChildren().contains(testResult.getUuid())).collect(Collectors.toList());
    }
}

