/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.test;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.qameta.allure.Allure;
import io.qameta.allure.test.AllureResults;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

public final class AllureTestCommonsUtils {
    private static final ObjectWriter WRITER = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME, true)).serializationInclusion(JsonInclude.Include.NON_NULL)).build()).writerWithDefaultPrettyPrinter();

    private AllureTestCommonsUtils() {
        throw new IllegalStateException("do not instance");
    }

    public static void attach(AllureResults allureResults) {
        allureResults.getTestResults().forEach(testResult -> {
            try {
                Allure.addAttachment((String)(testResult.getUuid() + "-result.json"), (String)WRITER.writeValueAsString(testResult));
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
        });
        allureResults.getTestResultContainers().forEach(container -> {
            try {
                Allure.addAttachment((String)(container.getUuid() + "-container.json"), (String)WRITER.writeValueAsString(container));
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
        });
        allureResults.getAttachments().forEach((fileName, body) -> Allure.addAttachment((String)fileName, (InputStream)new ByteArrayInputStream((byte[])body)));
    }
}

