/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.httpclient;

import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentProcessor;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentProcessor;
import io.qameta.allure.attachment.FreemarkerAttachmentRenderer;
import io.qameta.allure.attachment.http.HttpResponseAttachment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class AllureHttpClientResponse
implements HttpResponseInterceptor {
    private final AttachmentRenderer<AttachmentData> renderer;
    private final AttachmentProcessor<AttachmentData> processor;

    public AllureHttpClientResponse() {
        this((AttachmentRenderer<AttachmentData>)new FreemarkerAttachmentRenderer("http-response.ftl"), (AttachmentProcessor<AttachmentData>)new DefaultAttachmentProcessor());
    }

    public AllureHttpClientResponse(AttachmentRenderer<AttachmentData> renderer, AttachmentProcessor<AttachmentData> processor) {
        this.renderer = renderer;
        this.processor = processor;
    }

    public void process(HttpResponse response, HttpContext context) throws IOException {
        HttpResponseAttachment.Builder builder = HttpResponseAttachment.Builder.create((String)"Response").setResponseCode(response.getStatusLine().getStatusCode());
        Stream.of(response.getAllHeaders()).forEach(header -> builder.setHeader(header.getName(), header.getValue()));
        LoggableEntity loggableEntity = new LoggableEntity(response.getEntity());
        response.setEntity((HttpEntity)loggableEntity);
        builder.setBody(loggableEntity.getBody());
        HttpResponseAttachment responseAttachment = builder.build();
        this.processor.addAttachment((AttachmentData)responseAttachment, this.renderer);
    }

    private static class LoggableEntity
    extends HttpEntityWrapper {
        private final byte[] rawContent;

        LoggableEntity(HttpEntity wrappedEntity) throws IOException {
            super(wrappedEntity);
            this.rawContent = EntityUtils.toByteArray((HttpEntity)wrappedEntity);
        }

        public String getBody() {
            return new String(this.rawContent, StandardCharsets.UTF_8);
        }

        public InputStream getContent() {
            return new ByteArrayInputStream(this.rawContent);
        }
    }
}

