/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.httpclient;

import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentProcessor;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentProcessor;
import io.qameta.allure.attachment.FreemarkerAttachmentRenderer;
import io.qameta.allure.attachment.http.HttpResponseAttachment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class AllureHttpClientResponse
implements HttpResponseInterceptor {
    private final AttachmentRenderer<AttachmentData> renderer;
    private final AttachmentProcessor<AttachmentData> processor;

    public AllureHttpClientResponse() {
        this((AttachmentRenderer<AttachmentData>)new FreemarkerAttachmentRenderer("http-response.ftl"), (AttachmentProcessor<AttachmentData>)new DefaultAttachmentProcessor());
    }

    public AllureHttpClientResponse(AttachmentRenderer<AttachmentData> renderer, AttachmentProcessor<AttachmentData> processor) {
        this.renderer = renderer;
        this.processor = processor;
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpResponseAttachment.Builder builder = HttpResponseAttachment.Builder.create((String)"Response").withResponseCode(response.getStatusLine().getStatusCode());
        Stream.of(response.getAllHeaders()).forEach(header -> builder.withHeader(header.getName(), header.getValue()));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        response.getEntity().writeTo((OutputStream)os);
        String body = new String(os.toByteArray(), StandardCharsets.UTF_8);
        builder.withBody(body);
        HttpResponseAttachment responseAttachment = builder.build();
        this.processor.addAttachment((AttachmentData)responseAttachment, this.renderer);
    }
}

