/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.httpclient;

import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentProcessor;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentProcessor;
import io.qameta.allure.attachment.FreemarkerAttachmentRenderer;
import io.qameta.allure.attachment.http.HttpRequestAttachment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class AllureHttpClientRequest
implements HttpRequestInterceptor {
    private final AttachmentRenderer<AttachmentData> renderer;
    private final AttachmentProcessor<AttachmentData> processor;

    public AllureHttpClientRequest() {
        this((AttachmentRenderer<AttachmentData>)new FreemarkerAttachmentRenderer("http-request.ftl"), (AttachmentProcessor<AttachmentData>)new DefaultAttachmentProcessor());
    }

    public AllureHttpClientRequest(AttachmentRenderer<AttachmentData> renderer, AttachmentProcessor<AttachmentData> processor) {
        this.renderer = renderer;
        this.processor = processor;
    }

    private static String getAttachmentName(HttpRequest request) {
        return String.format("Request_%s_%s", request.getRequestLine().getMethod(), request.getRequestLine().getUri());
    }

    public void process(HttpRequest request, HttpContext context) throws IOException {
        HttpEntity entity;
        HttpRequestAttachment.Builder builder = HttpRequestAttachment.Builder.create((String)AllureHttpClientRequest.getAttachmentName(request), (String)request.getRequestLine().getUri()).setMethod(request.getRequestLine().getMethod());
        Stream.of(request.getAllHeaders()).forEach(header -> builder.setHeader(header.getName(), header.getValue()));
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)os);
            String body = new String(os.toByteArray(), StandardCharsets.UTF_8);
            builder.setBody(body);
        }
        HttpRequestAttachment requestAttachment = builder.build();
        this.processor.addAttachment((AttachmentData)requestAttachment, this.renderer);
    }
}

