/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import ch.qos.logback.classic.Level;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import io.qameta.allure.Commands;
import io.qameta.allure.ExitCode;
import io.qameta.allure.command.GenerateCommand;
import io.qameta.allure.command.MainCommand;
import io.qameta.allure.command.OpenCommand;
import io.qameta.allure.command.PluginCommand;
import io.qameta.allure.command.ServeCommand;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLine {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLine.class);
    protected static final String PROGRAM_NAME = "allure";
    protected static final String SERVE_COMMAND = "serve";
    protected static final String GENERATE_COMMAND = "generate";
    protected static final String OPEN_COMMAND = "open";
    protected static final String PLUGIN_COMMAND = "plugin";
    private final MainCommand mainCommand;
    private final ServeCommand serveCommand;
    private final GenerateCommand generateCommand;
    private final OpenCommand openCommand;
    private final PluginCommand pluginCommand;
    private final Commands commands;
    private final JCommander commander;

    public CommandLine(Path allureHome) {
        this(new Commands(allureHome));
    }

    public CommandLine(Commands commands) {
        this.commands = commands;
        this.mainCommand = new MainCommand();
        this.serveCommand = new ServeCommand();
        this.generateCommand = new GenerateCommand();
        this.openCommand = new OpenCommand();
        this.pluginCommand = new PluginCommand();
        this.commander = new JCommander((Object)this.mainCommand);
        this.commander.addCommand(GENERATE_COMMAND, (Object)this.generateCommand);
        this.commander.addCommand(SERVE_COMMAND, (Object)this.serveCommand);
        this.commander.addCommand(OPEN_COMMAND, (Object)this.openCommand);
        this.commander.addCommand(PLUGIN_COMMAND, (Object)this.pluginCommand);
        this.commander.setProgramName(PROGRAM_NAME);
    }

    public static void main(String[] args) throws InterruptedException {
        CommandLine commandLine;
        String allureHome = System.getenv("APP_HOME");
        if (Objects.isNull(allureHome)) {
            LOGGER.info("APP_HOME is not set, using default configuration");
            commandLine = new CommandLine((Path)null);
        } else {
            commandLine = new CommandLine(Paths.get(allureHome, new String[0]));
        }
        ExitCode exitCode = commandLine.parse(args).orElseGet(commandLine::run);
        System.exit(exitCode.getCode());
    }

    public Optional<ExitCode> parse(String ... args) {
        if (args.length == 0) {
            this.printUsage(this.commander);
            return Optional.of(ExitCode.ARGUMENT_PARSING_ERROR);
        }
        try {
            this.commander.parse(args);
        }
        catch (ParameterException e) {
            LOGGER.debug("Error during arguments parsing", (Throwable)e);
            LOGGER.info("Could not parse arguments: {}", (Object)e.getMessage());
            this.printUsage(this.commander);
            return Optional.of(ExitCode.ARGUMENT_PARSING_ERROR);
        }
        List<Path> reportDirectories = this.openCommand.getReportDirectories();
        if (reportDirectories.size() != 1) {
            LOGGER.error("Only one main argument is allowed");
            return Optional.of(ExitCode.ARGUMENT_PARSING_ERROR);
        }
        return Optional.empty();
    }

    public ExitCode run() {
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        if (this.mainCommand.getVerboseOptions().isQuiet()) {
            rootLogger.setLevel(Level.OFF);
        }
        if (this.mainCommand.getVerboseOptions().isVerbose()) {
            rootLogger.setLevel(Level.DEBUG);
        }
        if (this.mainCommand.isVersion()) {
            String toolVersion = CommandLine.class.getPackage().getImplementationVersion();
            System.out.println(Objects.isNull(toolVersion) ? "unknown" : toolVersion);
            return ExitCode.NO_ERROR;
        }
        if (this.mainCommand.isHelp()) {
            this.printUsage(this.commander);
            return ExitCode.NO_ERROR;
        }
        String parsedCommand = this.commander.getParsedCommand();
        if (Objects.isNull(parsedCommand)) {
            this.printUsage(this.commander);
            return ExitCode.ARGUMENT_PARSING_ERROR;
        }
        switch (parsedCommand) {
            case "generate": {
                return this.commands.generate(this.generateCommand.getReportDirectory(), this.generateCommand.getResultsOptions().getResultsDirectories(), this.generateCommand.isCleanReportDirectory(), this.generateCommand.isSingleFileMode(), this.generateCommand.getConfigOptions(), this.generateCommand.getReportNameOptions(), this.generateCommand.getReportLanguageOptions());
            }
            case "serve": {
                return this.commands.serve(this.serveCommand.getResultsOptions().getResultsDirectories(), this.serveCommand.getHostPortOptions().getHost(), this.serveCommand.getHostPortOptions().getPort(), this.serveCommand.getConfigOptions(), this.serveCommand.getReportNameOptions(), this.serveCommand.getReportLanguageOptions());
            }
            case "open": {
                return this.commands.open(this.openCommand.getReportDirectories().get(0), this.openCommand.getHostPortOptions().getHost(), this.openCommand.getHostPortOptions().getPort());
            }
            case "plugin": {
                return this.commands.listPlugins(this.pluginCommand.getConfigOptions());
            }
        }
        this.printUsage(this.commander);
        return ExitCode.ARGUMENT_PARSING_ERROR;
    }

    public JCommander getCommander() {
        return this.commander;
    }

    public MainCommand getMainCommand() {
        return this.mainCommand;
    }

    private void printUsage(JCommander commander) {
        commander.usage();
    }
}

