/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import io.qameta.allure.CommandlineConfig;
import io.qameta.allure.ConfigurationBuilder;
import io.qameta.allure.DefaultResultsVisitor;
import io.qameta.allure.ExitCode;
import io.qameta.allure.ReportGenerator;
import io.qameta.allure.config.ConfigLoader;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.option.ConfigOptions;
import io.qameta.allure.option.ReportLanguageOptions;
import io.qameta.allure.option.ReportNameOptions;
import io.qameta.allure.plugin.DefaultPluginLoader;
import io.qameta.allure.util.DeleteVisitor;
import java.awt.AWTError;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commands {
    private static final Logger LOGGER = LoggerFactory.getLogger(Commands.class);
    private static final String DIRECTORY_EXISTS_MESSAGE = "Allure: Target directory {} for the report is already in use, add a '--clean' option to overwrite";
    private final Path allureHome;

    public Commands(Path allureHome) {
        this.allureHome = allureHome;
    }

    public CommandlineConfig getConfig(ConfigOptions configOptions) {
        return this.getConfigFile(configOptions).map(ConfigLoader::new).map(ConfigLoader::load).orElseGet(CommandlineConfig::new);
    }

    public Optional<Path> getConfigFile(ConfigOptions configOptions) {
        if (Objects.nonNull(configOptions.getConfigPath())) {
            return Optional.of(Paths.get(configOptions.getConfigPath(), new String[0]));
        }
        if (Objects.nonNull(configOptions.getConfigDirectory())) {
            return Optional.of(Paths.get(configOptions.getConfigDirectory(), new String[0]).resolve(this.getConfigFileName(configOptions.getProfile())));
        }
        if (Objects.nonNull(this.allureHome)) {
            return Optional.of(this.allureHome.resolve("config").resolve(this.getConfigFileName(configOptions.getProfile())));
        }
        return Optional.empty();
    }

    public String getConfigFileName(String profile) {
        return Objects.isNull(profile) ? "allure.yml" : String.format("allure-%s.yml", profile);
    }

    private ExitCode generate(Path reportDirectory, List<Path> resultsDirectories, boolean clean, boolean singleFileMode, Configuration configuration) {
        boolean directoryExists = Files.exists(reportDirectory, new LinkOption[0]);
        if (clean && directoryExists) {
            FileUtils.deleteQuietly((File)reportDirectory.toFile());
        } else if (directoryExists && this.isDirectoryNotEmpty(reportDirectory)) {
            LOGGER.error(DIRECTORY_EXISTS_MESSAGE, (Object)reportDirectory.toAbsolutePath());
            return ExitCode.GENERIC_ERROR;
        }
        ReportGenerator generator = new ReportGenerator(configuration);
        if (singleFileMode) {
            generator.generateSingleFile(reportDirectory, resultsDirectories);
        } else {
            generator.generate(reportDirectory, resultsDirectories);
        }
        LOGGER.info("Report successfully generated to {}", (Object)reportDirectory);
        return ExitCode.NO_ERROR;
    }

    public ExitCode generate(Path reportDirectory, List<Path> resultsDirectories, boolean clean, boolean singleFileMode, ConfigOptions profile, ReportNameOptions reportNameOptions, ReportLanguageOptions reportLanguageOptions) {
        Configuration configuration = this.createReportConfiguration(profile, reportNameOptions, reportLanguageOptions);
        return this.generate(reportDirectory, resultsDirectories, clean, singleFileMode, configuration);
    }

    public ExitCode serve(List<Path> resultsDirectories, String host, int port, ConfigOptions configOptions, ReportNameOptions reportNameOptions, ReportLanguageOptions reportLanguageOptions) {
        Path reportDirectory;
        LOGGER.info("Generating report to temp directory...");
        try {
            Path tmp = Files.createTempDirectory("", new FileAttribute[0]);
            reportDirectory = tmp.resolve("allure-report");
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    LOGGER.info("Shutting down...");
                    Files.walkFileTree(tmp, (FileVisitor<? super Path>)new DeleteVisitor());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }));
        }
        catch (IOException e) {
            LOGGER.error("Could not create temp directory", (Throwable)e);
            return ExitCode.GENERIC_ERROR;
        }
        Configuration configuration = this.createReportConfiguration(configOptions, reportNameOptions, reportLanguageOptions);
        ExitCode exitCode = this.generate(reportDirectory, resultsDirectories, false, false, configuration);
        if (exitCode.isSuccess()) {
            return this.open(reportDirectory, host, port);
        }
        return exitCode;
    }

    public ExitCode open(Path reportDirectory, String host, int port) {
        HttpServer server;
        LOGGER.info("Starting web server...");
        try {
            server = this.setUpServer(host, port, reportDirectory);
            server.start();
        }
        catch (Exception e) {
            LOGGER.error("Could not serve the report", (Throwable)e);
            return ExitCode.GENERIC_ERROR;
        }
        InetSocketAddress socketAddress = server.getAddress();
        URI uri = URI.create("http://" + socketAddress.getHostString() + ":" + socketAddress.getPort());
        try {
            this.openBrowser(uri);
        }
        catch (AWTError | IOException e) {
            LOGGER.error("Could not open the report in browser, try to open it manually {}", (Object)uri, (Object)e);
        }
        LOGGER.info("Server started at <{}>. Press <Ctrl+C> to exit", (Object)uri);
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException e) {
            LOGGER.error("Report serve interrupted", (Throwable)e);
            return ExitCode.GENERIC_ERROR;
        }
        return ExitCode.NO_ERROR;
    }

    public ExitCode listPlugins(ConfigOptions configOptions) {
        CommandlineConfig config = this.getConfig(configOptions);
        config.getPlugins().forEach(System.out::println);
        return ExitCode.NO_ERROR;
    }

    protected Configuration createReportConfiguration(ConfigOptions profile, ReportNameOptions reportNameOptions, ReportLanguageOptions reportLanguageOptions) {
        DefaultPluginLoader loader = new DefaultPluginLoader();
        CommandlineConfig commandlineConfig = this.getConfig(profile);
        ClassLoader classLoader = this.getClass().getClassLoader();
        List plugins = commandlineConfig.getPlugins().stream().map(name -> loader.loadPlugin(classLoader, this.allureHome.resolve("plugins").resolve((String)name))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return ConfigurationBuilder.bundled().withPlugins(plugins).withReportName(reportNameOptions.getReportName()).withReportLanguage(reportLanguageOptions.getReportLanguage()).build();
    }

    protected HttpServer setUpServer(String host, int port, Path reportDirectory) throws IOException {
        HttpServer server = HttpServer.create(new InetSocketAddress(Objects.isNull(host) ? "localhost" : host, port), 0);
        server.createContext("/", exchange -> {
            Path resolve = reportDirectory.resolve("." + exchange.getRequestURI().getPath());
            if (Files.isDirectory(resolve, new LinkOption[0])) {
                Commands.serveFile(exchange, resolve.resolve("index.html"));
            } else {
                Commands.serveFile(exchange, resolve);
            }
        });
        return server;
    }

    private static void serveFile(HttpExchange exchange, Path resolve) throws IOException {
        if (Files.isRegularFile(resolve, new LinkOption[0])) {
            String contentType = DefaultResultsVisitor.probeContentType((Path)resolve);
            exchange.sendResponseHeaders(200, Files.size(resolve));
            exchange.getResponseHeaders().add("Content-Type", contentType);
            try (OutputStream os = exchange.getResponseBody();){
                Files.copy(resolve, os);
            }
        }
        String response = "404 Not Found";
        exchange.sendResponseHeaders(404, "404 Not Found".length());
        try (OutputStream os = exchange.getResponseBody();){
            os.write("404 Not Found".getBytes(StandardCharsets.UTF_8));
        }
    }

    protected void openBrowser(URI url) throws IOException {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(url);
            }
            catch (UnsupportedOperationException e) {
                LOGGER.error("Browse operation is not supported on your platform.You can use the link below to open the report manually.", (Throwable)e);
            }
        } else {
            LOGGER.error("Can not open browser because this capability is not supported on your platform. You can use the link below to open the report manually.");
        }
    }

    private boolean isDirectoryNotEmpty(Path path) {
        boolean bl;
        block8: {
            DirectoryStream<Path> stream = Files.newDirectoryStream(path);
            try {
                bl = stream.iterator().hasNext();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("Could not scan report directory {}", (Object)path, (Object)e);
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }
}

