/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.xray;

import io.qameta.allure.Aggregator;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.ExecutorInfo;
import io.qameta.allure.entity.Link;
import io.qameta.allure.entity.Status;
import io.qameta.allure.jira.JiraIssueComment;
import io.qameta.allure.jira.JiraService;
import io.qameta.allure.jira.JiraServiceBuilder;
import io.qameta.allure.jira.XrayTestRun;
import io.qameta.allure.util.PropertyUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrayTestRunExportPlugin
implements Aggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XrayTestRunExportPlugin.class);
    private static final String EXECUTORS_BLOCK_NAME = "executor";
    private static final String ALLURE_XRAY_ENABLED = "ALLURE_XRAY_ENABLED";
    private static final String ALLURE_XRAY_EXECUTION_ISSUES = "ALLURE_XRAY_EXECUTION_ISSUES";
    private static final String ALLURE_XRAY_STATUS_UNKNOWN = "ALLURE_XRAY_STATUS_UNKNOWN";
    private static final String ALLURE_XRAY_STATUS_SKIPPED = "ALLURE_XRAY_STATUS_SKIPPED";
    private static final String ALLURE_XRAY_STATUS_BROKEN = "ALLURE_XRAY_STATUS_BROKEN";
    private static final String ALLURE_XRAY_STATUS_FAILED = "ALLURE_XRAY_STATUS_FAILED";
    private static final String ALLURE_XRAY_STATUS_PASSED = "ALLURE_XRAY_STATUS_PASSED";
    private static final String XRAY_STATUS_PASS = "PASS";
    private static final String XRAY_STATUS_FAIL = "FAIL";
    private static final String XRAY_STATUS_TODO = "TODO";
    private static final int JIRA_MAX_RESULTS = 1000;
    private final boolean enabled;
    private final String issues;
    private final Map<Status, String> statusesMap = XrayTestRunExportPlugin.getDefaultStatusesMap();
    private final Supplier<JiraService> jiraServiceSupplier;

    public XrayTestRunExportPlugin() {
        this(PropertyUtils.getProperty((String)ALLURE_XRAY_ENABLED).map(Boolean::parseBoolean).orElse(false), PropertyUtils.getProperty((String)ALLURE_XRAY_EXECUTION_ISSUES).orElse(""), XrayTestRunExportPlugin.getEnvStatusesMap(), () -> new JiraServiceBuilder().defaults().build());
    }

    public XrayTestRunExportPlugin(boolean enabled, String issues, Map<Status, String> statusesMap, Supplier<JiraService> jiraServiceSupplier) {
        this.enabled = enabled;
        this.issues = issues;
        this.statusesMap.putAll(statusesMap);
        this.jiraServiceSupplier = jiraServiceSupplier;
    }

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) {
        if (this.enabled) {
            this.updateTestRunStatuses(launchesResults);
        }
    }

    private void updateTestRunStatuses(List<LaunchResults> launchesResults) {
        List<String> executionIssues = XrayTestRunExportPlugin.splitByComma(this.issues);
        JiraService jiraService = this.jiraServiceSupplier.get();
        Map testRunsMap = executionIssues.stream().map(issue -> this.getTestRunsInTestExecution(jiraService, (String)issue)).flatMap(Collection::stream).collect(Collectors.groupingBy(XrayTestRun::getKey, HashMap::new, Collectors.toCollection(ArrayList::new)));
        HashMap<String, String> linkNamePerStatus = new HashMap<String, String>();
        launchesResults.stream().map(LaunchResults::getAllResults).flatMap(Collection::stream).forEach(testResult -> {
            for (Link link : testResult.getLinks()) {
                if (!this.isTmsLink(link)) continue;
                String status = this.statusesMap.get(testResult.getStatus());
                LOGGER.debug(link.getName() + " with status " + status);
                switch (status) {
                    case "FAIL": {
                        linkNamePerStatus.put(link.getName(), status);
                        break;
                    }
                    case "TODO": {
                        if (linkNamePerStatus.containsKey(link.getName())) break;
                        linkNamePerStatus.put(link.getName(), status);
                        break;
                    }
                    case "PASS": {
                        if (linkNamePerStatus.containsKey(link.getName()) && !((String)linkNamePerStatus.get(link.getName())).equals(XRAY_STATUS_TODO)) break;
                        linkNamePerStatus.put(link.getName(), status);
                        break;
                    }
                }
            }
        });
        linkNamePerStatus.forEach((linkName, status) -> {
            List xrayTestRuns = (List)testRunsMap.get(linkName);
            if (xrayTestRuns != null) {
                xrayTestRuns.forEach(testRun -> this.updateTestRunStatus(jiraService, (XrayTestRun)testRun, (String)status));
            }
        });
        Optional<ExecutorInfo> executorInfo = launchesResults.stream().map(launchResults -> launchResults.getExtra(EXECUTORS_BLOCK_NAME)).filter(Optional::isPresent).map(Optional::get).filter(ExecutorInfo.class::isInstance).map(ExecutorInfo.class::cast).findFirst();
        executorInfo.ifPresent(info -> executionIssues.forEach(issue -> this.addExecutionComment(jiraService, (String)issue, (ExecutorInfo)info)));
    }

    private void addExecutionComment(JiraService jiraService, String executionIssueKey, ExecutorInfo info) {
        try {
            String message = String.format("Execution updated from launch [%s|%s]", info.getBuildName(), info.getReportUrl());
            jiraService.createIssueComment(executionIssueKey, new JiraIssueComment().setBody(message));
            LOGGER.debug(String.format("Xray execution '%s' commented successfully", executionIssueKey));
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Xray execution '%s' comment failed", executionIssueKey));
        }
    }

    private void updateTestRunStatus(JiraService jiraService, XrayTestRun testRun, String status) {
        if (!status.equals(testRun.getStatus())) {
            try {
                jiraService.updateTestRunStatus(Integer.valueOf(testRun.getId()), status);
                LOGGER.debug(String.format("Xray testrun '%s' (id: '%s') status updated to '%s' successfully", testRun.getKey(), testRun.getId(), status));
            }
            catch (Exception e) {
                LOGGER.error(String.format("Xray testrun '%s' (id: '%s') status update failed", testRun.getKey(), testRun.getId()));
            }
        }
    }

    private static Map<Status, String> getEnvStatusesMap() {
        HashMap<Status, String> statues = new HashMap<Status, String>();
        PropertyUtils.getProperty((String)ALLURE_XRAY_STATUS_PASSED).ifPresent(value -> statues.put(Status.PASSED, (String)value));
        PropertyUtils.getProperty((String)ALLURE_XRAY_STATUS_FAILED).ifPresent(value -> statues.put(Status.FAILED, (String)value));
        PropertyUtils.getProperty((String)ALLURE_XRAY_STATUS_BROKEN).ifPresent(value -> statues.put(Status.BROKEN, (String)value));
        PropertyUtils.getProperty((String)ALLURE_XRAY_STATUS_SKIPPED).ifPresent(value -> statues.put(Status.SKIPPED, (String)value));
        PropertyUtils.getProperty((String)ALLURE_XRAY_STATUS_UNKNOWN).ifPresent(value -> statues.put(Status.UNKNOWN, (String)value));
        return statues;
    }

    private static Map<Status, String> getDefaultStatusesMap() {
        HashMap<Status, String> statues = new HashMap<Status, String>();
        statues.put(Status.PASSED, XRAY_STATUS_PASS);
        statues.put(Status.FAILED, XRAY_STATUS_FAIL);
        statues.put(Status.BROKEN, XRAY_STATUS_FAIL);
        statues.put(Status.SKIPPED, XRAY_STATUS_TODO);
        statues.put(Status.UNKNOWN, XRAY_STATUS_TODO);
        return statues;
    }

    private boolean isTmsLink(Link link) {
        return "tms".equals(link.getType());
    }

    private static List<String> splitByComma(String value) {
        return Arrays.stream(value.split(",")).map(String::trim).collect(Collectors.toList());
    }

    private List<XrayTestRun> getTestRunsInTestExecution(JiraService jiraService, String executionKey) {
        List pageTestRuns;
        ArrayList<XrayTestRun> results = new ArrayList<XrayTestRun>();
        int page = 1;
        do {
            pageTestRuns = jiraService.getTestRunsForTestExecution(executionKey, page++);
            results.addAll(pageTestRuns);
        } while (pageTestRuns.size() == 1000);
        return results;
    }
}

