/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.CommandlineConfig;
import io.qameta.allure.ConfigurationBuilder;
import io.qameta.allure.ExitCode;
import io.qameta.allure.ReportGenerator;
import io.qameta.allure.config.ConfigLoader;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.option.ConfigOptions;
import io.qameta.allure.plugin.DefaultPluginLoader;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commands {
    private static final Logger LOGGER = LoggerFactory.getLogger(Commands.class);
    private static final String DIRECTORY_EXISTS_MESSAGE = "Allure: Target directory {} for the report is already in use, add a '--clean' option to overwrite";
    private final Path allureHome;

    public Commands(Path allureHome) {
        this.allureHome = allureHome;
    }

    public CommandlineConfig getConfig(ConfigOptions configOptions) {
        return this.getConfigFile(configOptions).map(ConfigLoader::new).map(ConfigLoader::load).orElseGet(CommandlineConfig::new);
    }

    public Optional<Path> getConfigFile(ConfigOptions configOptions) {
        if (Objects.nonNull(configOptions.getConfigPath())) {
            return Optional.of(Paths.get(configOptions.getConfigPath(), new String[0]));
        }
        if (Objects.nonNull(configOptions.getConfigDirectory())) {
            return Optional.of(Paths.get(configOptions.getConfigDirectory(), new String[0]).resolve(this.getConfigFileName(configOptions.getProfile())));
        }
        if (Objects.nonNull(this.allureHome)) {
            return Optional.of(this.allureHome.resolve("config").resolve(this.getConfigFileName(configOptions.getProfile())));
        }
        return Optional.empty();
    }

    public String getConfigFileName(String profile) {
        return Objects.isNull(profile) ? "allure.yml" : String.format("allure-%s.yml", profile);
    }

    public ExitCode generate(Path reportDirectory, List<Path> resultsDirectories, boolean clean, ConfigOptions profile) {
        boolean directoryExists = Files.exists(reportDirectory, new LinkOption[0]);
        if (clean && directoryExists) {
            FileUtils.deleteQuietly((File)reportDirectory.toFile());
        } else if (directoryExists && this.isDirectoryNotEmpty(reportDirectory)) {
            LOGGER.error(DIRECTORY_EXISTS_MESSAGE, (Object)reportDirectory.toAbsolutePath());
            return ExitCode.GENERIC_ERROR;
        }
        try {
            ReportGenerator generator = new ReportGenerator(this.createReportConfiguration(profile));
            generator.generate(reportDirectory, resultsDirectories);
        }
        catch (IOException e) {
            LOGGER.error("Could not generate report", (Throwable)e);
            return ExitCode.GENERIC_ERROR;
        }
        LOGGER.info("Report successfully generated to {}", (Object)reportDirectory);
        return ExitCode.NO_ERROR;
    }

    public ExitCode serve(List<Path> resultsDirectories, String host, int port, ConfigOptions configOptions) {
        Path reportDirectory;
        LOGGER.info("Generating report to temp directory...");
        try {
            Path tmp = Files.createTempDirectory("", new FileAttribute[0]);
            reportDirectory = tmp.resolve("allure-report");
            tmp.toFile().deleteOnExit();
        }
        catch (IOException e) {
            LOGGER.error("Could not create temp directory", (Throwable)e);
            return ExitCode.GENERIC_ERROR;
        }
        ExitCode exitCode = this.generate(reportDirectory, resultsDirectories, false, configOptions);
        if (exitCode.isSuccess()) {
            return this.open(reportDirectory, host, port);
        }
        return exitCode;
    }

    public ExitCode open(Path reportDirectory, String host, int port) {
        Server server;
        LOGGER.info("Starting web server...");
        try {
            server = this.setUpServer(host, port, reportDirectory);
            server.start();
        }
        catch (Exception e) {
            LOGGER.error("Could not serve the report", (Throwable)e);
            return ExitCode.GENERIC_ERROR;
        }
        try {
            this.openBrowser(server.getURI());
        }
        catch (IOException e) {
            LOGGER.error("Could not open the report in browser, try to open it manually {}: {}", (Object)server.getURI(), (Object)e);
        }
        LOGGER.info("Server started at <{}>. Press <Ctrl+C> to exit", (Object)server.getURI());
        try {
            server.join();
        }
        catch (InterruptedException e) {
            LOGGER.error("Report serve interrupted", (Throwable)e);
            return ExitCode.GENERIC_ERROR;
        }
        return ExitCode.NO_ERROR;
    }

    public ExitCode listPlugins(ConfigOptions configOptions) {
        CommandlineConfig config = this.getConfig(configOptions);
        config.getPlugins().forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        return ExitCode.NO_ERROR;
    }

    protected Configuration createReportConfiguration(ConfigOptions profile) {
        DefaultPluginLoader loader = new DefaultPluginLoader();
        CommandlineConfig commandlineConfig = this.getConfig(profile);
        ClassLoader classLoader = this.getClass().getClassLoader();
        List plugins = commandlineConfig.getPlugins().stream().map(name -> loader.loadPlugin(classLoader, this.allureHome.resolve("plugins").resolve((String)name))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return new ConfigurationBuilder().useDefault().fromPlugins(plugins).build();
    }

    protected Server setUpServer(String host, int port, Path reportDirectory) throws IOException {
        Server server = Objects.isNull(host) ? new Server(port) : new Server(new InetSocketAddress(host, port));
        ResourceHandler handler = new ResourceHandler();
        handler.setRedirectWelcome(true);
        handler.setDirectoriesListed(true);
        handler.setPathInfoOnly(true);
        handler.setBaseResource(Resource.newResource((Path)reportDirectory.toRealPath(new LinkOption[0])));
        server.setStopAtShutdown(true);
        server.setHandler((Handler)handler);
        return server;
    }

    protected void openBrowser(URI url) throws IOException {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(url);
            }
            catch (UnsupportedOperationException e) {
                LOGGER.error("Browse operation is not supported on your platform.You can use the link below to open the report manually.", (Throwable)e);
            }
        } else {
            LOGGER.error("Can not open browser because this capability is not supported on your platform. You can use the link below to open the report manually.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDirectoryNotEmpty(Path path) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            boolean bl = stream.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            LOGGER.warn("Could not scan report directory {}", (Object)path, (Object)e);
            return false;
        }
    }
}

