/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.assertj;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.ResultsUtils;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AllureAspectJ {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureAspectJ.class);
    private static AllureLifecycle lifecycle;

    @Around(value="execution(* org.assertj.core.api.AbstractAssert+.*(..)) || execution(* org.assertj.core.api.Assertions.assertThat(..))")
    public Object step(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String name = joinPoint.getArgs().length > 0 ? String.format("%s '%s'", methodSignature.getName(), AllureAspectJ.arrayToString(joinPoint.getArgs())) : methodSignature.getName();
        String uuid = UUID.randomUUID().toString();
        StepResult result = new StepResult().withName(name);
        AllureAspectJ.getLifecycle().startStep(uuid, result);
        try {
            Object proceed = joinPoint.proceed();
            AllureAspectJ.getLifecycle().updateStep(uuid, s -> s.withStatus(Status.PASSED));
            Object object = proceed;
            return object;
        }
        catch (Throwable e) {
            AllureAspectJ.getLifecycle().updateStep(uuid, s -> s.withStatus(ResultsUtils.getStatus((Throwable)e).orElse(Status.BROKEN)).withStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)e).orElse(null)));
            throw e;
        }
        finally {
            AllureAspectJ.getLifecycle().stopStep(uuid);
        }
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle = allure;
    }

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = Allure.getLifecycle();
        }
        return lifecycle;
    }

    private static String arrayToString(Object ... array) {
        return Stream.of(array).map(object -> {
            if (object.getClass().isArray()) {
                return AllureAspectJ.arrayToString((Object[])object);
            }
            return Objects.toString(object);
        }).collect(Collectors.joining(" "));
    }
}

