/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.vertx;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;

public class MetricsHandler
implements Handler<RoutingContext> {
    private CollectorRegistry registry;

    public MetricsHandler() {
        this(CollectorRegistry.defaultRegistry);
    }

    public MetricsHandler(CollectorRegistry registry) {
        this.registry = registry;
    }

    public void handle(RoutingContext ctx) {
        try {
            BufferWriter writer = new BufferWriter();
            TextFormat.write004((Writer)writer, (Enumeration)this.registry.metricFamilySamples());
            ctx.response().setStatusCode(200).putHeader("Content-Type", "text/plain; version=0.0.4; charset=utf-8").end(writer.getBuffer());
        }
        catch (IOException e) {
            ctx.fail((Throwable)e);
        }
    }

    private static class BufferWriter
    extends Writer {
        private final Buffer buffer = Buffer.buffer();

        private BufferWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.buffer.appendString(new String(cbuf, off, len));
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        Buffer getBuffer() {
            return this.buffer;
        }
    }
}

