/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.spring.boot;

import io.prometheus.client.exporter.common.TextFormat;
import io.prometheus.client.spring.boot.PrometheusEndpoint;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ConfigurationProperties(value="endpoints.prometheus")
public class PrometheusMvcEndpoint
extends EndpointMvcAdapter {
    private final PrometheusEndpoint delgate;

    public PrometheusMvcEndpoint(PrometheusEndpoint delegate) {
        super((Endpoint)delegate);
        this.delgate = delegate;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"*/*"})
    @ResponseBody
    public ResponseEntity value(@RequestParam(value="name[]", required=false, defaultValue="") Set<String> name, @RequestHeader(value="Accept", required=false, defaultValue="") String accept) {
        if (!this.getDelegate().isEnabled()) {
            return this.getDisabledResponse();
        }
        String contentType = TextFormat.chooseContentType((String)accept);
        String result = this.delgate.writeRegistry(name, contentType);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{contentType})).body((Object)result);
    }
}

