/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.bridge;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Graphite {
    private static final Logger logger = Logger.getLogger(Graphite.class.getName());
    private final String host;
    private final int port;
    private static final Pattern INVALID_GRAPHITE_CHARS = Pattern.compile("[^a-zA-Z0-9_-]");

    public Graphite(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void push(CollectorRegistry registry) throws IOException {
        Socket s = new Socket(this.host, this.port);
        BufferedWriter writer = new BufferedWriter(new PrintWriter(s.getOutputStream()));
        Matcher m = INVALID_GRAPHITE_CHARS.matcher("");
        long now = System.currentTimeMillis() / 1000L;
        for (Collector.MetricFamilySamples metricFamilySamples : Collections.list(registry.metricFamilySamples())) {
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                m.reset(sample.name);
                writer.write(m.replaceAll("_"));
                for (int i = 0; i < sample.labelNames.size(); ++i) {
                    m.reset((CharSequence)sample.labelValues.get(i));
                    writer.write("." + (String)sample.labelNames.get(i) + "." + m.replaceAll("_"));
                }
                writer.write(" " + sample.value + " " + now + "\n");
            }
        }
        writer.close();
        s.close();
    }

    public Thread start(CollectorRegistry registry) {
        return this.start(registry, 60);
    }

    public Thread start(CollectorRegistry registry, int intervalSeconds) {
        PushThread thread = new PushThread(registry, intervalSeconds);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    private class PushThread
    extends Thread {
        private final CollectorRegistry registry;
        private final int intervalSeconds;

        PushThread(CollectorRegistry registry, int intervalSeconds) {
            this.registry = registry;
            this.intervalSeconds = intervalSeconds;
        }

        @Override
        public void run() {
            long waitUntil = System.currentTimeMillis();
            while (true) {
                try {
                    Graphite.this.push(this.registry);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Exception " + e + " pushing to " + Graphite.this.host + ":" + Graphite.this.port, e);
                }
                long now = System.currentTimeMillis();
                while (now >= waitUntil) {
                    waitUntil += (long)(this.intervalSeconds * 1000);
                }
                try {
                    Thread.sleep(waitUntil - now);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

