/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class SimpleCollector<Child, T extends SimpleCollector>
extends Collector {
    protected final String fullname;
    protected final String help;
    protected final List<String> labelNames;
    protected final ConcurrentMap<List<String>, Child> children = new ConcurrentHashMap<List<String>, Child>();
    protected Child noLabelsChild;

    public Child labels(String ... labelValues) {
        if (labelValues.length != this.labelNames.size()) {
            throw new IllegalArgumentException("Incorrect number of labels.");
        }
        List<String> key = Arrays.asList(labelValues);
        Object c = this.children.get(key);
        if (c != null) {
            return (Child)c;
        }
        this.children.putIfAbsent(key, this.newChild());
        return (Child)this.children.get(key);
    }

    public void remove(String ... labelValues) {
        this.children.remove(Arrays.asList(labelValues));
        if (this.labelNames.size() == 0) {
            this.noLabelsChild = this.labels(new String[0]);
        }
    }

    public void clear() {
        this.children.clear();
        if (this.labelNames.size() == 0) {
            this.noLabelsChild = this.labels(new String[0]);
        }
    }

    public <T extends Collector> T setChild(Child child, String ... labelValues) {
        if (labelValues.length != this.labelNames.size()) {
            throw new IllegalArgumentException("Incorrect number of labels.");
        }
        this.children.put(Arrays.asList(labelValues), child);
        return (T)this;
    }

    protected abstract Child newChild();

    protected SimpleCollector(Builder b) {
        if (b.name.isEmpty()) {
            throw new IllegalStateException("Name hasn't been set.");
        }
        String name = b.name;
        if (!b.subsystem.isEmpty()) {
            name = b.subsystem + '_' + name;
        }
        if (!b.namespace.isEmpty()) {
            name = b.namespace + '_' + name;
        }
        this.fullname = name;
        if (b.help.isEmpty()) {
            throw new IllegalStateException("Help hasn't been set.");
        }
        this.help = b.help;
        this.labelNames = Arrays.asList(b.labelNames);
        if (this.labelNames.size() == 0) {
            this.noLabelsChild = this.labels(new String[0]);
        }
    }

    public static abstract class Builder<T extends SimpleCollector> {
        String namespace = "";
        String subsystem = "";
        String name = "";
        String fullname = "";
        String help = "";
        String[] labelNames = new String[0];

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> subsystem(String subsystem) {
            this.subsystem = subsystem;
            return this;
        }

        public Builder<T> namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder<T> help(String help) {
            this.help = help;
            return this;
        }

        public Builder<T> labelNames(String ... labelNames) {
            this.labelNames = labelNames;
            return this;
        }

        public abstract T create();

        public T register() {
            return this.register(CollectorRegistry.defaultRegistry);
        }

        public T register(CollectorRegistry registry) {
            T sc = this.create();
            registry.register((Collector)sc);
            return sc;
        }
    }
}

