/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Collector;
import io.prometheus.client.SimpleCollector;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Summary
extends SimpleCollector<Child> {
    public Summary(Builder b) {
        super(b);
        if (this.labelNames.length == 0) {
            ((Child)this.labels(new String[0])).set(0.0, 0.0);
        }
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child();
    }

    public void observe(double amt) {
        ((Child)this.labels(new String[0])).observe(amt);
    }

    @Override
    public Collector.MetricFamilySamples[] collect() {
        Vector<Collector.MetricFamilySamples.Sample> samples = new Vector<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            Child.Value v = ((Child)c.getValue()).get();
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_count", this.labelNames, (List)c.getKey(), v.count));
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_sum", this.labelNames, (List)c.getKey(), v.sum));
        }
        Collector.MetricFamilySamples mfs = new Collector.MetricFamilySamples(this.fullname, Collector.Type.SUMMARY, this.help, samples);
        return new Collector.MetricFamilySamples[]{mfs};
    }

    public static class Child {
        private final Value value = new Value();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void observe(double amt) {
            Child child = this;
            synchronized (child) {
                Value.access$008(this.value);
                this.value.sum += amt;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(double c, double s) {
            Child child = this;
            synchronized (child) {
                this.value.count = c;
                this.value.sum = s;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Value get() {
            Value v = new Value();
            Child child = this;
            synchronized (child) {
                v.sum = this.value.sum;
                v.count = this.value.count;
            }
            return v;
        }

        public static class Value {
            private volatile double count;
            private volatile double sum;

            static /* synthetic */ double access$008(Value x0) {
                double d = x0.count;
                x0.count = d + 1.0;
                return d;
            }
        }
    }

    public static class Builder
    extends SimpleCollector.Builder {
        @Override
        public SimpleCollector create() {
            return new Summary(this);
        }
    }
}

