/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Collector;
import io.prometheus.client.SimpleCollector;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Gauge
extends SimpleCollector<Child> {
    public Gauge(Builder b) {
        super(b);
        if (this.labelNames.length == 0) {
            this.set(0.0);
        }
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child();
    }

    public void inc() {
        this.inc(1.0);
    }

    public void inc(double amt) {
        ((Child)this.labels(new String[0])).inc(amt);
    }

    public void dec() {
        this.dec(1.0);
    }

    public void dec(double amt) {
        ((Child)this.labels(new String[0])).dec(amt);
    }

    public void set(double val) {
        ((Child)this.labels(new String[0])).set(val);
    }

    @Override
    public Collector.MetricFamilySamples[] collect() {
        Vector<Collector.MetricFamilySamples.Sample> samples = new Vector<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname, this.labelNames, (List)c.getKey(), ((Child)c.getValue()).get()));
        }
        Collector.MetricFamilySamples mfs = new Collector.MetricFamilySamples(this.fullname, Collector.Type.GAUGE, this.help, samples);
        return new Collector.MetricFamilySamples[]{mfs};
    }

    public static class Child {
        private volatile double value;

        public void inc() {
            this.inc(1.0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void inc(double amt) {
            Child child = this;
            synchronized (child) {
                this.value += amt;
            }
        }

        public void dec() {
            this.dec(1.0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dec(double amt) {
            Child child = this;
            synchronized (child) {
                this.value -= amt;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(double val) {
            Child child = this;
            synchronized (child) {
                this.value = val;
            }
        }

        public double get() {
            return this.value;
        }
    }

    public static class Builder
    extends SimpleCollector.Builder {
        @Override
        public SimpleCollector create() {
            return new Gauge(this);
        }
    }
}

