/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.org.eclipse.jetty.io;

import io.prometheus.jmx.shaded.org.eclipse.jetty.io.AbstractBuffers;
import io.prometheus.jmx.shaded.org.eclipse.jetty.io.Buffer;
import io.prometheus.jmx.shaded.org.eclipse.jetty.io.Buffers;

public class ThreadLocalBuffers
extends AbstractBuffers {
    private final ThreadLocal<ThreadBuffers> _buffers = new ThreadLocal<ThreadBuffers>(){

        @Override
        protected ThreadBuffers initialValue() {
            return new ThreadBuffers();
        }
    };

    public ThreadLocalBuffers(Buffers.Type headerType, int headerSize, Buffers.Type bufferType, int bufferSize, Buffers.Type otherType) {
        super(headerType, headerSize, bufferType, bufferSize, otherType);
    }

    @Override
    public Buffer getBuffer() {
        ThreadBuffers buffers = this._buffers.get();
        if (buffers._buffer != null) {
            Buffer b = buffers._buffer;
            buffers._buffer = null;
            return b;
        }
        if (buffers._other != null && this.isBuffer(buffers._other)) {
            Buffer b = buffers._other;
            buffers._other = null;
            return b;
        }
        return this.newBuffer();
    }

    @Override
    public Buffer getHeader() {
        ThreadBuffers buffers = this._buffers.get();
        if (buffers._header != null) {
            Buffer b = buffers._header;
            buffers._header = null;
            return b;
        }
        if (buffers._other != null && this.isHeader(buffers._other)) {
            Buffer b = buffers._other;
            buffers._other = null;
            return b;
        }
        return this.newHeader();
    }

    @Override
    public Buffer getBuffer(int size) {
        ThreadBuffers buffers = this._buffers.get();
        if (buffers._other != null && buffers._other.capacity() == size) {
            Buffer b = buffers._other;
            buffers._other = null;
            return b;
        }
        return this.newBuffer(size);
    }

    @Override
    public void returnBuffer(Buffer buffer) {
        buffer.clear();
        if (buffer.isVolatile() || buffer.isImmutable()) {
            return;
        }
        ThreadBuffers buffers = this._buffers.get();
        if (buffers._header == null && this.isHeader(buffer)) {
            buffers._header = buffer;
        } else if (buffers._buffer == null && this.isBuffer(buffer)) {
            buffers._buffer = buffer;
        } else {
            buffers._other = buffer;
        }
    }

    @Override
    public String toString() {
        return "{{" + this.getHeaderSize() + "," + this.getBufferSize() + "}}";
    }

    protected static class ThreadBuffers {
        Buffer _buffer;
        Buffer _header;
        Buffer _other;

        protected ThreadBuffers() {
        }
    }
}

